/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfk;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgw
extends zzfk<Float>
implements zzhg<Float>,
RandomAccess {
    private static final zzgw zzsc = new zzgw();
    private float[] zzsd;
    private int size;

    zzgw() {
        this(new float[10], 0);
    }

    private zzgw(float[] fArray, int n) {
        this.zzsd = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbc();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsd, n2, this.zzsd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgw)) {
            return super.equals(object);
        }
        zzgw zzgw2 = (zzgw)object;
        if (this.size != zzgw2.size) {
            return false;
        }
        float[] fArray = zzgw2.zzsd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsd[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzsd[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzf(float f) {
        this.zze(this.size, f);
    }

    private final void zze(int n, float f) {
        this.zzbc();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
        if (this.size < this.zzsd.length) {
            System.arraycopy(this.zzsd, n, this.zzsd, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsd, 0, fArray, 0, n);
            System.arraycopy(this.zzsd, n, fArray, n + 1, this.size - n);
            this.zzsd = fArray;
        }
        this.zzsd[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzbc();
        zzhb.checkNotNull(collection);
        if (!(collection instanceof zzgw)) {
            return super.addAll(collection);
        }
        zzgw zzgw2 = (zzgw)collection;
        if (zzgw2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgw2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgw2.size;
        if (n > this.zzsd.length) {
            this.zzsd = Arrays.copyOf(this.zzsd, n);
        }
        System.arraycopy(zzgw2.zzsd, 0, this.zzsd, this.size, zzgw2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbc();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzsd[i]))) continue;
            System.arraycopy(this.zzsd, i + 1, this.zzsd, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzac(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
    }

    private final String zzad(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzgw zzgw2 = this;
        zzgw2.zzbc();
        zzgw2.zzac(n);
        float f3 = zzgw2.zzsd[n];
        zzgw2.zzsd[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgw zzgw2 = this;
        zzgw2.zzbc();
        zzgw2.zzac(n);
        float f = zzgw2.zzsd[n];
        if (n < zzgw2.size - 1) {
            System.arraycopy(zzgw2.zzsd, n + 1, zzgw2.zzsd, n, zzgw2.size - n);
        }
        --zzgw2.size;
        ++zzgw2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zze(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzhg zzae(int n) {
        int n2 = n;
        zzgw zzgw2 = this;
        if (n2 < zzgw2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgw(Arrays.copyOf(zzgw2.zzsd, n2), zzgw2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgw zzgw2 = this;
        zzgw2.zzac(n);
        return Float.valueOf(zzgw2.zzsd[n]);
    }

    static {
        zzsc.zzbb();
    }
}

