/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.zzb;
import com.google.android.gms.location.places.ui.zzc;
import com.google.android.gms.maps.model.LatLngBounds;

public class PlaceAutocomplete
extends zzb {
    public static final int RESULT_ERROR = 2;
    public static final int MODE_FULLSCREEN = 1;
    public static final int MODE_OVERLAY = 2;

    private PlaceAutocomplete() {
    }

    public static Place getPlace(Context context, Intent intent) {
        return zzb.getPlace(context, intent);
    }

    public static Status getStatus(Context context, Intent intent) {
        return zzb.getStatus(context, intent);
    }

    public static class IntentBuilder
    extends zzc {
        public IntentBuilder(int n) {
            super("com.google.android.gms.location.places.ui.AUTOCOMPLETE");
            this.intent.putExtra("gmscore_client_jar_version", GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE);
            this.intent.putExtra("mode", n);
            this.intent.putExtra("origin", 2);
        }

        public IntentBuilder setBoundsBias(@Nullable LatLngBounds latLngBounds) {
            if (latLngBounds != null) {
                this.intent.putExtra("bounds", (Parcelable)latLngBounds);
            } else {
                this.intent.removeExtra("bounds");
            }
            return this;
        }

        public IntentBuilder setFilter(@Nullable AutocompleteFilter autocompleteFilter) {
            if (autocompleteFilter != null) {
                this.intent.putExtra("filter", (Parcelable)autocompleteFilter);
            } else {
                this.intent.removeExtra("filter");
            }
            return this;
        }

        public final IntentBuilder zzg(int n) {
            this.intent.putExtra("origin", 1);
            return this;
        }

        public final IntentBuilder zzh(@Nullable String string) {
            if (string != null) {
                this.intent.putExtra("initial_query", string);
            } else {
                this.intent.removeExtra("initial_query");
            }
            return this;
        }

        @Override
        public Intent build(Activity activity) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
            return super.build(activity);
        }
    }
}

