/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzbd;
import com.google.android.gms.internal.places.zzbh;
import com.google.android.gms.internal.places.zzcw;
import com.google.android.gms.internal.places.zzq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbb
extends zzq<Float>
implements zzbh<Float>,
zzcw,
RandomAccess {
    private static final zzbb zzic = new zzbb(new float[0], 0);
    private float[] zzid;
    private int size;

    zzbb() {
        this(new float[10], 0);
    }

    private zzbb(float[] fArray, int n) {
        this.zzid = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzac();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzid, n2, this.zzid, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbb)) {
            return super.equals(object);
        }
        zzbb zzbb2 = (zzbb)object;
        if (this.size != zzbb2.size) {
            return false;
        }
        float[] fArray = zzbb2.zzid;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzid[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzid[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzf(float f) {
        this.zzd(this.size, f);
    }

    private final void zzd(int n, float f) {
        this.zzac();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzid.length) {
            System.arraycopy(this.zzid, n, this.zzid, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzid, 0, fArray, 0, n);
            System.arraycopy(this.zzid, n, fArray, n + 1, this.size - n);
            this.zzid = fArray;
        }
        this.zzid[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzac();
        zzbd.checkNotNull(collection);
        if (!(collection instanceof zzbb)) {
            return super.addAll(collection);
        }
        zzbb zzbb2 = (zzbb)collection;
        if (zzbb2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbb2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbb2.size;
        if (n > this.zzid.length) {
            this.zzid = Arrays.copyOf(this.zzid, n);
        }
        System.arraycopy(zzbb2.zzid, 0, this.zzid, this.size, zzbb2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzac();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzid[i]))) continue;
            System.arraycopy(this.zzid, i + 1, this.zzid, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzbb zzbb2 = this;
        zzbb2.zzac();
        zzbb2.zzf(n);
        float f3 = zzbb2.zzid[n];
        zzbb2.zzid[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbb zzbb2 = this;
        zzbb2.zzac();
        zzbb2.zzf(n);
        float f = zzbb2.zzid[n];
        if (n < zzbb2.size - 1) {
            System.arraycopy(zzbb2.zzid, n + 1, zzbb2.zzid, n, zzbb2.size - n - 1);
        }
        --zzbb2.size;
        ++zzbb2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzd(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzbh zzh(int n) {
        int n2 = n;
        zzbb zzbb2 = this;
        if (n2 < zzbb2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbb(Arrays.copyOf(zzbb2.zzid, n2), zzbb2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbb zzbb2 = this;
        zzbb2.zzf(n);
        return Float.valueOf(zzbb2.zzid[n]);
    }

    static {
        zzic.zzab();
    }
}

