/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzbd;
import com.google.android.gms.internal.places.zzbh;
import com.google.android.gms.internal.places.zzcw;
import com.google.android.gms.internal.places.zzq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzby
extends zzq<Long>
implements zzbh<Long>,
zzcw,
RandomAccess {
    private static final zzby zzkg = new zzby(new long[0], 0);
    private long[] zzkh;
    private int size;

    zzby() {
        this(new long[10], 0);
    }

    private zzby(long[] lArray, int n) {
        this.zzkh = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzac();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzkh, n2, this.zzkh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzby)) {
            return super.equals(object);
        }
        zzby zzby2 = (zzby)object;
        if (this.size != zzby2.size) {
            return false;
        }
        long[] lArray = zzby2.zzkh;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzkh[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzbd.zzl(this.zzkh[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzf(n);
        return this.zzkh[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzm(long l) {
        this.zzl(this.size, l);
    }

    private final void zzl(int n, long l) {
        this.zzac();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzkh.length) {
            System.arraycopy(this.zzkh, n, this.zzkh, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzkh, 0, lArray, 0, n);
            System.arraycopy(this.zzkh, n, lArray, n + 1, this.size - n);
            this.zzkh = lArray;
        }
        this.zzkh[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzac();
        zzbd.checkNotNull(collection);
        if (!(collection instanceof zzby)) {
            return super.addAll(collection);
        }
        zzby zzby2 = (zzby)collection;
        if (zzby2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzby2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzby2.size;
        if (n > this.zzkh.length) {
            this.zzkh = Arrays.copyOf(this.zzkh, n);
        }
        System.arraycopy(zzby2.zzkh, 0, this.zzkh, this.size, zzby2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzac();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzkh[i])) continue;
            System.arraycopy(this.zzkh, i + 1, this.zzkh, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzby zzby2 = this;
        zzby2.zzac();
        zzby2.zzf(n);
        long l3 = zzby2.zzkh[n];
        zzby2.zzkh[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzby zzby2 = this;
        zzby2.zzac();
        zzby2.zzf(n);
        long l = zzby2.zzkh[n];
        if (n < zzby2.size - 1) {
            System.arraycopy(zzby2.zzkh, n + 1, zzby2.zzkh, n, zzby2.size - n - 1);
        }
        --zzby2.size;
        ++zzby2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzl(n, l);
    }

    @Override
    public final /* synthetic */ zzbh zzh(int n) {
        int n2 = n;
        zzby zzby2 = this;
        if (n2 < zzby2.size) {
            throw new IllegalArgumentException();
        }
        return new zzby(Arrays.copyOf(zzby2.zzkh, n2), zzby2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzkg.zzab();
    }
}

