/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzbd;
import com.google.android.gms.internal.places.zzbh;
import com.google.android.gms.internal.places.zzcw;
import com.google.android.gms.internal.places.zzq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzu
extends zzq<Boolean>
implements zzbh<Boolean>,
zzcw,
RandomAccess {
    private static final zzu zzed = new zzu(new boolean[0], 0);
    private boolean[] zzee;
    private int size;

    zzu() {
        this(new boolean[10], 0);
    }

    private zzu(boolean[] blArray, int n) {
        this.zzee = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzac();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzee, n2, this.zzee, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzu)) {
            return super.equals(object);
        }
        zzu zzu2 = (zzu)object;
        if (this.size != zzu2.size) {
            return false;
        }
        boolean[] blArray = zzu2.zzee;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzee[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzbd.zze(this.zzee[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzb(this.size, bl);
    }

    private final void zzb(int n, boolean bl) {
        this.zzac();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzee.length) {
            System.arraycopy(this.zzee, n, this.zzee, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzee, 0, blArray, 0, n);
            System.arraycopy(this.zzee, n, blArray, n + 1, this.size - n);
            this.zzee = blArray;
        }
        this.zzee[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzac();
        zzbd.checkNotNull(collection);
        if (!(collection instanceof zzu)) {
            return super.addAll(collection);
        }
        zzu zzu2 = (zzu)collection;
        if (zzu2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzu2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzu2.size;
        if (n > this.zzee.length) {
            this.zzee = Arrays.copyOf(this.zzee, n);
        }
        System.arraycopy(zzu2.zzee, 0, this.zzee, this.size, zzu2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzac();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzee[i])) continue;
            System.arraycopy(this.zzee, i + 1, this.zzee, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzu zzu2 = this;
        zzu2.zzac();
        zzu2.zzf(n);
        boolean bl3 = zzu2.zzee[n];
        zzu2.zzee[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzu zzu2 = this;
        zzu2.zzac();
        zzu2.zzf(n);
        boolean bl = zzu2.zzee[n];
        if (n < zzu2.size - 1) {
            System.arraycopy(zzu2.zzee, n + 1, zzu2.zzee, n, zzu2.size - n - 1);
        }
        --zzu2.size;
        ++zzu2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zzb(n, bl);
    }

    @Override
    public final /* synthetic */ zzbh zzh(int n) {
        int n2 = n;
        zzu zzu2 = this;
        if (n2 < zzu2.size) {
            throw new IllegalArgumentException();
        }
        return new zzu(Arrays.copyOf(zzu2.zzee, n2), zzu2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzu zzu2 = this;
        zzu2.zzf(n);
        return zzu2.zzee[n];
    }

    static {
        zzed.zzab();
    }
}

