/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.places.zzc;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Deprecated
@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="AddPlaceRequestCreator")
public class AddPlaceRequest
extends AbstractSafeParcelable {
    @SafeParcelable.Field(id=1, getter="getName")
    private final String name;
    @SafeParcelable.Field(id=2, getter="getLatLng")
    private final LatLng latLng;
    @SafeParcelable.Field(id=3, getter="getAddress")
    private final String zzf;
    @SafeParcelable.Field(id=4, getter="getPlaceTypes")
    private final List<Integer> zzg;
    @SafeParcelable.Field(id=5, getter="getPhoneNumber")
    private final String zzh;
    @SafeParcelable.Field(id=6, getter="getWebsiteUri")
    private final Uri zzi;
    public static final Parcelable.Creator<AddPlaceRequest> CREATOR = new zzc();

    @SafeParcelable.Constructor
    public AddPlaceRequest(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) List<Integer> list, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Uri uri) {
        this.name = Preconditions.checkNotEmpty((String)string);
        this.latLng = (LatLng)Preconditions.checkNotNull((Object)latLng);
        this.zzf = Preconditions.checkNotEmpty((String)string2);
        this.zzg = new ArrayList<Integer>((Collection)Preconditions.checkNotNull(list));
        Preconditions.checkArgument((!this.zzg.isEmpty() ? 1 : 0) != 0, (Object)"At least one place type should be provided.");
        Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)string3) || uri != null ? 1 : 0) != 0, (Object)"One of phone number or URI should be provided.");
        this.zzh = string3;
        this.zzi = uri;
    }

    public AddPlaceRequest(String string, LatLng latLng, String string2, List<Integer> list, String string3) {
        this(string, latLng, string2, list, Preconditions.checkNotEmpty((String)string3), null);
    }

    public AddPlaceRequest(String string, LatLng latLng, String string2, List<Integer> list, Uri uri) {
        this(string, latLng, string2, list, null, (Uri)Preconditions.checkNotNull((Object)uri));
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AddPlaceRequest addPlaceRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)addPlaceRequest.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)addPlaceRequest.getLatLng(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)addPlaceRequest.getAddress(), (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)4, addPlaceRequest.getPlaceTypes(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)addPlaceRequest.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)addPlaceRequest.getWebsiteUri(), (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public String getName() {
        return this.name;
    }

    public LatLng getLatLng() {
        return this.latLng;
    }

    public String getAddress() {
        return this.zzf;
    }

    public List<Integer> getPlaceTypes() {
        return this.zzg;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.zzh;
    }

    @Nullable
    public Uri getWebsiteUri() {
        return this.zzi;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("latLng", (Object)this.latLng).add("address", (Object)this.zzf).add("placeTypes", this.zzg).add("phoneNumer", (Object)this.zzh).add("websiteUri", (Object)this.zzi).toString();
    }
}

