/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.plus.zzr;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class PlusShare {
    @Deprecated
    public static final String EXTRA_CONTENT_URL = "com.google.android.apps.plus.CONTENT_URL";
    @Deprecated
    public static final String EXTRA_CONTENT_DEEP_LINK_ID = "com.google.android.apps.plus.CONTENT_DEEP_LINK_ID";
    @Deprecated
    public static final String EXTRA_CONTENT_DEEP_LINK_METADATA = "com.google.android.apps.plus.CONTENT_DEEP_LINK_METADATA";
    @Deprecated
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_TITLE = "title";
    @Deprecated
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION = "description";
    @Deprecated
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL = "thumbnailUrl";
    @Deprecated
    public static final String EXTRA_IS_INTERACTIVE_POST = "com.google.android.apps.plus.GOOGLE_INTERACTIVE_POST";
    @Deprecated
    public static final String EXTRA_CALL_TO_ACTION = "com.google.android.apps.plus.CALL_TO_ACTION";
    @Deprecated
    public static final String KEY_CALL_TO_ACTION_LABEL = "label";
    @Deprecated
    public static final String KEY_CALL_TO_ACTION_URL = "url";
    @Deprecated
    public static final String KEY_CALL_TO_ACTION_DEEP_LINK_ID = "deepLinkId";
    @Deprecated
    public static final String EXTRA_SENDER_ID = "com.google.android.apps.plus.SENDER_ID";
    @Deprecated
    public static final String PARAM_CONTENT_DEEP_LINK_ID = "deep_link_id";

    @Deprecated
    protected PlusShare() {
        throw new AssertionError();
    }

    @Deprecated
    public static String getDeepLinkId(Intent intent) {
        String string = null;
        if (intent != null && intent.getData() != null) {
            string = intent.getData().getQueryParameter(PARAM_CONTENT_DEEP_LINK_ID);
        }
        return string;
    }

    @Deprecated
    @VisibleForTesting
    public static Person createPerson(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("MinimalPerson ID must not be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Display name must not be empty.");
        }
        return new zzr(string2, string, null, 0, null);
    }

    @VisibleForTesting
    protected static boolean zza(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.e((String)"GooglePlusPlatform", (String)"The provided deep-link ID is empty.");
            return false;
        }
        if (string.contains(" ")) {
            Log.e((String)"GooglePlusPlatform", (String)"Spaces are not allowed in deep-link IDs.");
            return false;
        }
        return true;
    }

    @Deprecated
    @VisibleForTesting
    public static class Builder {
        private final Context mContext;
        private final Intent mIntent;
        private boolean zzp;
        private ArrayList<Uri> zzq;

        @Deprecated
        public Builder(Context context) {
            this.mContext = context;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
        }

        @Deprecated
        public Builder(Activity activity) {
            this.mContext = activity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.addFlags(524288);
            if (activity != null && activity.getComponentName() != null) {
                this.zzp = true;
            }
        }

        @Deprecated
        public Builder setType(String string) {
            this.mIntent.setType(string);
            return this;
        }

        @Deprecated
        public Builder setRecipients(Person person, List<Person> list) {
            this.mIntent.putExtra(PlusShare.EXTRA_SENDER_ID, person != null ? person.getId() : "0");
            int n = list != null ? list.size() : 0;
            if (n == 0) {
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_IDS");
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES");
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            for (Person person2 : list) {
                arrayList.add(person2.getId());
                arrayList2.add(person2.getDisplayName());
            }
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_IDS", arrayList);
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES", arrayList2);
            return this;
        }

        @Deprecated
        public Builder setText(CharSequence charSequence) {
            this.mIntent.putExtra("android.intent.extra.TEXT", charSequence);
            return this;
        }

        @Deprecated
        public Builder setStream(Uri uri) {
            this.zzq = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            return this;
        }

        @Deprecated
        public Builder addStream(Uri uri) {
            Uri uri2 = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri2 == null) {
                return this.setStream(uri);
            }
            if (this.zzq == null) {
                this.zzq = new ArrayList();
            }
            this.zzq.add(uri2);
            this.zzq.add(uri);
            return this;
        }

        @Deprecated
        public Builder setContentUrl(Uri uri) {
            String string = null;
            if (uri != null) {
                string = uri.toString();
            }
            if (TextUtils.isEmpty(string)) {
                this.mIntent.removeExtra(PlusShare.EXTRA_CONTENT_URL);
            } else {
                this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_URL, string);
            }
            return this;
        }

        @Deprecated
        public Builder setContentDeepLinkId(String string) {
            return this.setContentDeepLinkId(string, null, null, null);
        }

        @Deprecated
        public Builder setContentDeepLinkId(String string, String string2, String string3, Uri uri) {
            Preconditions.checkArgument((boolean)this.zzp, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting deep links");
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)string) ? 1 : 0) != 0, (Object)"The deepLinkId parameter is required.");
            Uri uri2 = uri;
            String string4 = string3;
            String string5 = string2;
            Bundle bundle = new Bundle();
            bundle.putString(PlusShare.KEY_CONTENT_DEEP_LINK_METADATA_TITLE, string5);
            bundle.putString(PlusShare.KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION, string4);
            if (uri2 != null) {
                bundle.putString(PlusShare.KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL, uri2.toString());
            }
            Bundle bundle2 = bundle;
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID, string);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_METADATA, bundle2);
            this.mIntent.setType("text/plain");
            return this;
        }

        @Deprecated
        public Builder addCallToAction(String string, Uri uri, String string2) {
            Preconditions.checkState((boolean)this.zzp, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting call-to-action");
            Preconditions.checkArgument((uri != null && !TextUtils.isEmpty((CharSequence)uri.toString()) ? 1 : 0) != 0, (Object)"Must provide a call to action URL");
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_LABEL, string);
            }
            bundle.putString(PlusShare.KEY_CALL_TO_ACTION_URL, uri.toString());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Preconditions.checkState((boolean)PlusShare.zza(string2), (Object)"The specified deep-link ID was malformed.");
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_DEEP_LINK_ID, string2);
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CALL_TO_ACTION, bundle);
            this.mIntent.putExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, true);
            this.mIntent.setType("text/plain");
            return this;
        }

        @Deprecated
        public Intent getIntent() {
            boolean bl = this.zzq != null && this.zzq.size() > 1;
            boolean bl2 = "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
            boolean bl3 = this.mIntent.getBooleanExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, false);
            Preconditions.checkState((!bl || !bl3 ? 1 : 0) != 0, (Object)"Call-to-action buttons are only available for URLs.");
            Preconditions.checkState((!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) ? 1 : 0) != 0, (Object)"The content URL is required for interactive posts.");
            Preconditions.checkState((!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID) ? 1 : 0) != 0, (Object)"Must set content URL or content deep-link ID to use a call-to-action button.");
            if (this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)) {
                Preconditions.checkState((boolean)PlusShare.zza(this.mIntent.getStringExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)), (Object)"The specified deep-link ID was malformed.");
            }
            if (!bl && bl2) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.zzq != null && !this.zzq.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.zzq.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.zzq = null;
            }
            if (bl && !bl2) {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                if (this.zzq != null && !this.zzq.isEmpty()) {
                    this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.zzq);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
            }
            if ("com.google.android.gms.plus.action.SHARE_INTERNAL_GOOGLE".equals(this.mIntent.getAction())) {
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            if (!this.mIntent.hasExtra("android.intent.extra.STREAM")) {
                this.mIntent.setAction("com.google.android.gms.plus.action.SHARE_GOOGLE");
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            this.mIntent.setPackage("com.google.android.apps.plus");
            return this.mIntent;
        }
    }
}

