/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzln;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzc<zze> zzKh = new Api.zzc();
    static final Api.zzb<zze, PlusOptions> zzKi = new Api.zzb<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zze2, new PlusSession(zze2.zzlD(), zzif.zzc((Set)zze2.zzlH()), plusOptions.zzayO.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api("Plus.API", zzKi, zzKh, new Scope[0]);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final Moments MomentsApi = new zzlo();
    public static final People PeopleApi = new zzlp();
    public static final Account AccountApi = new zzll();
    public static final zzb zzayL = new zzln();
    public static final com.google.android.gms.plus.zza zzayM = new zzlm();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzv.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzv.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzv.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(zzKh) : null;
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzKh, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzayN;
        final Set<String> zzayO;

        private PlusOptions() {
            this.zzayN = null;
            this.zzayO = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzayN = builder.zzayN;
            this.zzayO = builder.zzayO;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzayN;
            final Set<String> zzayO = new HashSet<String>();

            public Builder setServerClientId(String clientId) {
                this.zzayN = clientId;
                return this;
            }

            public Builder addActivityTypes(String ... activityTypes) {
                zzv.zzb((Object)activityTypes, (Object)"activityTypes may not be null.");
                for (int i = 0; i < activityTypes.length; ++i) {
                    this.zzayO.add(activityTypes[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

