/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View zzayP;
    private int mSize;
    private int zzayQ;
    private String zzAX;
    private int zzayR;
    private OnPlusOneClickListener zzayS;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.zzayQ = PlusOneButton.getAnnotation(context, attrs);
        this.zzayR = -1;
        this.zzS(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attrs) {
        String string = zzac.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attrs, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attrs) {
        String string = zzac.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attrs, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzS(Context context) {
        if (this.zzayP != null) {
            this.removeView(this.zzayP);
        }
        this.zzayP = zzg.zza(context, this.mSize, this.zzayQ, this.zzAX, this.zzayR);
        this.setOnPlusOneClickListener(this.zzayS);
        this.addView(this.zzayP);
    }

    public void initialize(String url, int activityRequestCode) {
        zzv.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzAX = url;
        this.zzayR = activityRequestCode;
        this.zzS(this.getContext());
    }

    public void initialize(String url, OnPlusOneClickListener plusOneClickListener) {
        this.zzAX = url;
        this.zzayR = 0;
        this.zzS(this.getContext());
        this.setOnPlusOneClickListener(plusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener listener) {
        this.zzayS = listener;
        this.zzayP.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(listener));
    }

    public void setAnnotation(int annotation) {
        this.zzayQ = annotation;
        this.zzS(this.getContext());
    }

    public void setSize(int size) {
        this.mSize = size;
        this.zzS(this.getContext());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View view = this.zzayP;
        this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.zzayP.layout(0, 0, right - left, bottom - top);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener zzayT;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener proxy) {
            this.zzayT = proxy;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.zzayP.getTag();
            if (this.zzayT != null) {
                this.zzayT.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.zzayR);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

