/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.plus.internal.model.people.PersonEntity;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.List;

public final class PlusShare {
    public static final String EXTRA_CONTENT_URL = "com.google.android.apps.plus.CONTENT_URL";
    public static final String EXTRA_CONTENT_DEEP_LINK_ID = "com.google.android.apps.plus.CONTENT_DEEP_LINK_ID";
    public static final String EXTRA_CONTENT_DEEP_LINK_METADATA = "com.google.android.apps.plus.CONTENT_DEEP_LINK_METADATA";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_TITLE = "title";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION = "description";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL = "thumbnailUrl";
    public static final String EXTRA_IS_INTERACTIVE_POST = "com.google.android.apps.plus.GOOGLE_INTERACTIVE_POST";
    public static final String EXTRA_CALL_TO_ACTION = "com.google.android.apps.plus.CALL_TO_ACTION";
    public static final String KEY_CALL_TO_ACTION_LABEL = "label";
    public static final String KEY_CALL_TO_ACTION_URL = "url";
    public static final String KEY_CALL_TO_ACTION_DEEP_LINK_ID = "deepLinkId";
    public static final String EXTRA_SENDER_ID = "com.google.android.apps.plus.SENDER_ID";
    public static final String PARAM_CONTENT_DEEP_LINK_ID = "deep_link_id";

    @Deprecated
    protected PlusShare() {
        throw new AssertionError();
    }

    public static String getDeepLinkId(Intent intent) {
        String string = null;
        if (intent != null && intent.getData() != null) {
            string = intent.getData().getQueryParameter(PARAM_CONTENT_DEEP_LINK_ID);
        }
        return string;
    }

    public static Bundle zza(String string, String string2, Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_TITLE, string);
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION, string2);
        if (uri != null) {
            bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL, uri.toString());
        }
        return bundle;
    }

    public static Person createPerson(String id, String displayName) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("MinimalPerson ID must not be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            throw new IllegalArgumentException("Display name must not be empty.");
        }
        return new PersonEntity(displayName, id, null, 0, null);
    }

    protected static boolean zzeP(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.e((String)"GooglePlusPlatform", (String)"The provided deep-link ID is empty.");
            return false;
        }
        if (string.contains(" ")) {
            Log.e((String)"GooglePlusPlatform", (String)"Spaces are not allowed in deep-link IDs.");
            return false;
        }
        return true;
    }

    public static class Builder {
        private final Context mContext;
        private final Intent mIntent;
        private boolean zzaYT;
        private ArrayList<Uri> zzaYU;

        public Builder(Context context) {
            this.mContext = context;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
        }

        public Builder(Activity launchingActivity) {
            this.mContext = launchingActivity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.addFlags(524288);
            if (launchingActivity != null && launchingActivity.getComponentName() != null) {
                this.zzaYT = true;
            }
        }

        public Builder setType(String mimeType) {
            this.mIntent.setType(mimeType);
            return this;
        }

        public Builder setRecipients(Person user, List<Person> recipientList) {
            int n;
            this.mIntent.putExtra(PlusShare.EXTRA_SENDER_ID, user != null ? user.getId() : "0");
            int n2 = n = recipientList != null ? recipientList.size() : 0;
            if (n == 0) {
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_IDS");
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES");
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            for (Person person : recipientList) {
                arrayList.add(person.getId());
                arrayList2.add(person.getDisplayName());
            }
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_IDS", arrayList);
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES", arrayList2);
            return this;
        }

        public Builder setText(CharSequence text) {
            this.mIntent.putExtra("android.intent.extra.TEXT", text);
            return this;
        }

        public Builder setStream(Uri streamUri) {
            this.zzaYU = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)streamUri);
            return this;
        }

        public Builder addStream(Uri streamUri) {
            Uri uri = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri == null) {
                return this.setStream(streamUri);
            }
            if (this.zzaYU == null) {
                this.zzaYU = new ArrayList();
            }
            this.zzaYU.add(uri);
            this.zzaYU.add(streamUri);
            return this;
        }

        public Builder setContentUrl(Uri uri) {
            String string = null;
            if (uri != null) {
                string = uri.toString();
            }
            if (TextUtils.isEmpty(string)) {
                this.mIntent.removeExtra(PlusShare.EXTRA_CONTENT_URL);
            } else {
                this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_URL, string);
            }
            return this;
        }

        public Builder setContentDeepLinkId(String deepLinkId) {
            return this.setContentDeepLinkId(deepLinkId, null, null, null);
        }

        public Builder setContentDeepLinkId(String deepLinkId, String title, String description, Uri thumbnailUri) {
            zzx.zzb((boolean)this.zzaYT, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting deep links");
            zzx.zzb((!TextUtils.isEmpty((CharSequence)deepLinkId) ? 1 : 0) != 0, (Object)"The deepLinkId parameter is required.");
            Bundle bundle = PlusShare.zza(title, description, thumbnailUri);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID, deepLinkId);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_METADATA, bundle);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Builder addCallToAction(String label, Uri uri, String deepLinkId) {
            zzx.zza((boolean)this.zzaYT, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting call-to-action");
            zzx.zzb((uri != null && !TextUtils.isEmpty((CharSequence)uri.toString()) ? 1 : 0) != 0, (Object)"Must provide a call to action URL");
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)label)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_LABEL, label);
            }
            bundle.putString(PlusShare.KEY_CALL_TO_ACTION_URL, uri.toString());
            if (!TextUtils.isEmpty((CharSequence)deepLinkId)) {
                zzx.zza((boolean)PlusShare.zzeP(deepLinkId), (Object)"The specified deep-link ID was malformed.");
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_DEEP_LINK_ID, deepLinkId);
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CALL_TO_ACTION, bundle);
            this.mIntent.putExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, true);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Intent getIntent() {
            boolean bl = this.zzaYU != null && this.zzaYU.size() > 1;
            boolean bl2 = "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
            boolean bl3 = this.mIntent.getBooleanExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, false);
            zzx.zza((!bl || !bl3 ? 1 : 0) != 0, (Object)"Call-to-action buttons are only available for URLs.");
            zzx.zza((!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) ? 1 : 0) != 0, (Object)"The content URL is required for interactive posts.");
            zzx.zza((!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID) ? 1 : 0) != 0, (Object)"Must set content URL or content deep-link ID to use a call-to-action button.");
            if (this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)) {
                zzx.zza((boolean)PlusShare.zzeP(this.mIntent.getStringExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)), (Object)"The specified deep-link ID was malformed.");
            }
            if (!bl && bl2) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.zzaYU != null && !this.zzaYU.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.zzaYU.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.zzaYU = null;
            }
            if (bl && !bl2) {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                if (this.zzaYU != null && !this.zzaYU.isEmpty()) {
                    this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.zzaYU);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
            }
            if ("com.google.android.gms.plus.action.SHARE_INTERNAL_GOOGLE".equals(this.mIntent.getAction())) {
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            if (!this.mIntent.hasExtra("android.intent.extra.STREAM")) {
                this.mIntent.setAction("com.google.android.gms.plus.action.SHARE_GOOGLE");
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            this.mIntent.setPackage("com.google.android.apps.plus");
            return this.mIntent;
        }
    }
}

