/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.plus.Account;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.internal.PlusCommonExtras;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.zze;
import com.google.android.gms.plus.zzb;
import java.util.HashSet;
import java.util.Set;

public final class Plus {
    public static final Api.zzc<zze> zzUI = new Api.zzc();
    static final Api.zza<zze, PlusOptions> zzUJ = new Api.zza<zze, PlusOptions>(){

        public zze zza(Context context, Looper looper, zzf zzf2, PlusOptions plusOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (plusOptions == null) {
                plusOptions = new PlusOptions();
            }
            return new zze(context, looper, zzf2, new PlusSession(zzf2.zzqq().name, zznh.zzc((Set)zzf2.zzqt()), plusOptions.zzbdZ.toArray(new String[0]), new String[0], context.getPackageName(), context.getPackageName(), null, new PlusCommonExtras()), connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 2;
        }
    };
    public static final Api<PlusOptions> API = new Api("Plus.API", zzUJ, zzUI);
    public static final Scope SCOPE_PLUS_LOGIN = new Scope("https://www.googleapis.com/auth/plus.login");
    public static final Scope SCOPE_PLUS_PROFILE = new Scope("https://www.googleapis.com/auth/plus.me");
    public static final Moments MomentsApi = new zzqy();
    public static final People PeopleApi = new zzqz();
    @Deprecated
    public static final Account AccountApi = new zzqv();
    public static final zzb zzbdW = new zzqx();
    public static final com.google.android.gms.plus.zza zzbdX = new zzqw();

    private Plus() {
    }

    public static zze zzf(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Plus.API Api. Pass this into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Plus.API and is not connected to Plus. Use GoogleApiClient.hasConnectedApi(Plus.API) to guard this call.");
        }
        return bl2 ? (zze)googleApiClient.zza(zzUI) : null;
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zze> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzUI, googleApiClient);
        }
    }

    public static final class PlusOptions
    implements Api.ApiOptions.Optional {
        final String zzbdY;
        final Set<String> zzbdZ;

        private PlusOptions() {
            this.zzbdY = null;
            this.zzbdZ = new HashSet<String>();
        }

        private PlusOptions(Builder builder) {
            this.zzbdY = builder.zzbdY;
            this.zzbdZ = builder.zzbdZ;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            String zzbdY;
            final Set<String> zzbdZ = new HashSet<String>();

            public Builder setServerClientId(String clientId) {
                this.zzbdY = clientId;
                return this;
            }

            public Builder addActivityTypes(String ... activityTypes) {
                zzx.zzb((Object)activityTypes, (Object)"activityTypes may not be null.");
                for (int i = 0; i < activityTypes.length; ++i) {
                    this.zzbdZ.add(activityTypes[i]);
                }
                return this;
            }

            public PlusOptions build() {
                return new PlusOptions(this);
            }
        }
    }
}

