/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzaj;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View aAN;
    private int mSize;
    private int aAO;
    private String zzae;
    private int aAP;
    private OnPlusOneClickListener aAQ;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSize = PlusOneButton.getSize(context, attributeSet);
        this.aAO = PlusOneButton.getAnnotation(context, attributeSet);
        this.aAP = -1;
        this.zzbw(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attributeSet) {
        String string = zzaj.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attributeSet) {
        String string = zzaj.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzbw(Context context) {
        if (this.aAN != null) {
            this.removeView(this.aAN);
        }
        this.aAN = zzg.zza(context, this.mSize, this.aAO, this.zzae, this.aAP);
        this.setOnPlusOneClickListener(this.aAQ);
        this.addView(this.aAN);
    }

    public void initialize(String string, int n) {
        zzaa.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzae = string;
        this.aAP = n;
        this.zzbw(this.getContext());
    }

    public void initialize(String string, OnPlusOneClickListener onPlusOneClickListener) {
        this.zzae = string;
        this.aAP = 0;
        this.zzbw(this.getContext());
        this.setOnPlusOneClickListener(onPlusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
        this.aAQ = onPlusOneClickListener;
        this.aAN.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(onPlusOneClickListener));
    }

    public void setAnnotation(int n) {
        this.aAO = n;
        this.zzbw(this.getContext());
    }

    public void setSize(int n) {
        this.mSize = n;
        this.zzbw(this.getContext());
    }

    protected void onMeasure(int n, int n2) {
        View view = this.aAN;
        this.measureChild(view, n, n2);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.aAN.layout(0, 0, n3 - n, n4 - n2);
    }

    public void plusOneClick() {
        this.aAN.performClick();
    }

    public void setIntent(Intent intent) {
        this.aAN.setTag((Object)intent);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener aAR;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
            this.aAR = onPlusOneClickListener;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.aAN.getTag();
            if (this.aAR != null) {
                this.aAR.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.aAP);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

