/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzcth;
import com.google.android.gms.internal.zzcti;
import com.google.android.gms.internal.zzctn;
import com.google.android.gms.internal.zzcto;
import com.google.android.gms.internal.zzctp;
import com.google.android.gms.internal.zzctq;
import com.google.android.gms.internal.zzctr;
import com.google.android.gms.internal.zzcts;
import com.google.android.gms.internal.zzctt;
import com.google.android.gms.internal.zzctu;
import com.google.android.gms.internal.zzctv;
import com.google.android.gms.internal.zzctw;
import com.google.android.gms.internal.zzctx;
import com.google.android.gms.internal.zzcty;
import com.google.android.gms.internal.zzcub;
import com.google.android.gms.internal.zzcud;
import com.google.android.gms.internal.zzcue;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzctm
implements SafetyNetApi {
    private static final String TAG = zzctm.class.getSimpleName();
    protected static SparseArray<zzcud> zzbBQ;
    protected static long zzbBR;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzctm.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.zzd((zzbck)new zzctn(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public final PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, List<Integer> list, String string, String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzbck)new zzcto(this, googleApiClient, list, string, string2));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzctm.zza(googleApiClient, string, 1, null, nArray);
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzctm.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzbck)new zzctp(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (zzbBQ == null || zzbBR == 0L || SystemClock.elapsedRealtime() - zzbBR >= 1200000L) {
            return true;
        }
        if (zzbBQ != null && zzbBQ.size() != 0) {
            List<zzcub> list = new zzcue(string).zzAi();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzcub zzcub2 : list) {
                int[] nArray2 = nArray;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    zzcud zzcud2 = (zzcud)zzbBQ.get(n2);
                    if (zzcud2 != null) {
                        if (!zzcud2.zzs(zzcub2.zzbt(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.VerifyAppsUserResult verifyAppsUserResult = (SafetyNetApi.VerifyAppsUserResult)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = verifyAppsUserResult != null && verifyAppsUserResult.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbck)new zzctq(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbck)new zzctr(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbck)new zzcts(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zzd((zzbck)new zzctt(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzf zzbCh;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.mStatus = status;
            this.zzbCh = zzf2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzbCh == null) {
                return null;
            }
            return this.zzbCh.getTokenResult();
        }
    }

    static abstract class zze
    extends zzcth<SafetyNetApi.RecaptchaTokenResult> {
        protected zzcti zzbCa = new zzctx(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends zzcth<SafetyNetApi.HarmfulAppsResult> {
        protected final zzcti zzbCa = new zzctw(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.HarmfulAppsResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzd zzbCg;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.mStatus = status;
            this.zzbCg = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzbCg == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzbCg.zzbBL);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzbCg == null) {
                return 0L;
            }
            return this.zzbCg.zzbBK;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static abstract class zzc
    extends zzcth<SafetyNetApi.VerifyAppsUserResult> {
        protected zzcti zzbCa = new zzctv(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.VerifyAppsUserResult {
        private Status mStatus;
        private boolean zzzH;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.mStatus = status;
            this.zzzH = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.mStatus != null && this.mStatus.isSuccess()) {
                return this.zzzH;
            }
            return false;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status mStatus;
        private final SafeBrowsingData zzbCi;
        private String zzbBM;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.mStatus = status;
            this.zzbCi = safeBrowsingData;
            this.zzbBM = null;
            if (this.zzbCi != null) {
                this.zzbBM = this.zzbCi.getMetadata();
                return;
            }
            if (this.mStatus.isSuccess()) {
                this.mStatus = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMetadata() {
            return this.zzbBM;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzbBM == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzbBM).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzcth<SafetyNetApi.SafeBrowsingResult> {
        protected zzcti zzbCa = new zzcty(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.AttestationResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zza zzbBZ;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.mStatus = status;
            this.zzbBZ = zza2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzbBZ == null) {
                return null;
            }
            return this.zzbBZ.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzcth<SafetyNetApi.AttestationResult> {
        protected zzcti zzbCa = new zzctu(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

