/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzcru;
import com.google.android.gms.internal.zzcrv;
import com.google.android.gms.internal.zzcsa;
import com.google.android.gms.internal.zzcsb;
import com.google.android.gms.internal.zzcsc;
import com.google.android.gms.internal.zzcsd;
import com.google.android.gms.internal.zzcse;
import com.google.android.gms.internal.zzcsf;
import com.google.android.gms.internal.zzcsg;
import com.google.android.gms.internal.zzcsh;
import com.google.android.gms.internal.zzcsi;
import com.google.android.gms.internal.zzcsj;
import com.google.android.gms.internal.zzcsk;
import com.google.android.gms.internal.zzcsl;
import com.google.android.gms.internal.zzcso;
import com.google.android.gms.internal.zzcsq;
import com.google.android.gms.internal.zzcsr;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzcrz
implements SafetyNetApi {
    private static final String TAG = zzcrz.class.getSimpleName();
    protected static SparseArray<zzcsq> zzbBM;
    protected static long zzbBN;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzcrz.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.zzd((zzbax)new zzcsa(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public final PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, List<Integer> list, String string, String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzbax)new zzcsb(this, googleApiClient, list, string, string2));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzcrz.zza(googleApiClient, string, 1, null, nArray);
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzcrz.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzd((zzbax)new zzcsc(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (zzbBM == null || zzbBN == 0L || SystemClock.elapsedRealtime() - zzbBN >= 1200000L) {
            return true;
        }
        if (zzbBM != null && zzbBM.size() != 0) {
            List<zzcso> list = new zzcsr(string).zzAk();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzcso zzcso2 : list) {
                int[] nArray2 = nArray;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    zzcsq zzcsq2 = (zzcsq)zzbBM.get(n2);
                    if (zzcsq2 != null) {
                        if (!zzcsq2.zzr(zzcso2.zzbu(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.VerifyAppsUserResult verifyAppsUserResult = (SafetyNetApi.VerifyAppsUserResult)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = verifyAppsUserResult != null && verifyAppsUserResult.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbax)new zzcsd(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbax)new zzcse(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zzd((zzbax)new zzcsf(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zzd((zzbax)new zzcsg(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzf zzbCd;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.mStatus = status;
            this.zzbCd = zzf2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzbCd == null) {
                return null;
            }
            return this.zzbCd.getTokenResult();
        }
    }

    static abstract class zze
    extends zzcru<SafetyNetApi.RecaptchaTokenResult> {
        protected zzcrv zzbBW = new zzcsk(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends zzcru<SafetyNetApi.HarmfulAppsResult> {
        protected final zzcrv zzbBW = new zzcsj(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.HarmfulAppsResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zzd zzbCc;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.mStatus = status;
            this.zzbCc = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzbCc == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzbCc.zzbBH);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzbCc == null) {
                return 0L;
            }
            return this.zzbCc.zzbBG;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static abstract class zzc
    extends zzcru<SafetyNetApi.VerifyAppsUserResult> {
        protected zzcrv zzbBW = new zzcsi(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.VerifyAppsUserResult {
        private Status mStatus;
        private boolean zzzG;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.mStatus = status;
            this.zzzG = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.mStatus != null && this.mStatus.isSuccess()) {
                return this.zzzG;
            }
            return false;
        }

        public final Status getStatus() {
            return this.mStatus;
        }
    }

    static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status mStatus;
        private final SafeBrowsingData zzbCe;
        private String zzbBI;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.mStatus = status;
            this.zzbCe = safeBrowsingData;
            this.zzbBI = null;
            if (this.zzbCe != null) {
                this.zzbBI = this.zzbCe.getMetadata();
                return;
            }
            if (this.mStatus.isSuccess()) {
                this.mStatus = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getMetadata() {
            return this.zzbBI;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzbBI == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzbBI).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzcru<SafetyNetApi.SafeBrowsingResult> {
        protected zzcrv zzbBW = new zzcsl(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.AttestationResult {
        private final Status mStatus;
        private final com.google.android.gms.safetynet.zza zzbBV;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.mStatus = status;
            this.zzbBV = zza2;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzbBV == null) {
                return null;
            }
            return this.zzbBV.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzcru<SafetyNetApi.AttestationResult> {
        protected zzcrv zzbBW = new zzcsh(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

