/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.safetynet;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.safetynet.zzj;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

@Hide
public class SafeBrowsingData
extends zzbgl {
    private static final String zza = SafeBrowsingData.class.getSimpleName();
    public static final Parcelable.Creator<SafeBrowsingData> CREATOR = new zzj();
    private String zzb;
    private DataHolder zzc;
    private ParcelFileDescriptor zzd;
    private long zze;
    private byte[] zzf;
    private byte[] zzg;
    private File zzh;

    public SafeBrowsingData(String string, DataHolder dataHolder, ParcelFileDescriptor parcelFileDescriptor, long l, byte[] byArray) {
        this.zzb = string;
        this.zzc = dataHolder;
        this.zzd = parcelFileDescriptor;
        this.zze = l;
        this.zzf = byArray;
    }

    public SafeBrowsingData(String string) {
        this(string, null, null, 0L, null);
    }

    public SafeBrowsingData(String string, DataHolder dataHolder) {
        this(string, dataHolder, null, 0L, null);
    }

    public SafeBrowsingData(long l, byte[] byArray) {
        this(null, null, null, l, byArray);
    }

    public SafeBrowsingData() {
        this(null, null, null, 0L, null);
    }

    public String getMetadata() {
        return this.zzb;
    }

    public DataHolder getBlacklistsDataHolder() {
        return this.zzc;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.zzd;
    }

    public long getLastUpdateTimeMs() {
        return this.zze;
    }

    public byte[] getState() {
        return this.zzf;
    }

    public void setBlacklists(byte[] byArray) {
        this.zzg = byArray;
    }

    public byte[] getBlacklists() {
        if (this.zzd == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzd));
        try {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            SafeBrowsingData.zza(dataInputStream);
            this.zzd = null;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        FileOutputStream fileOutputStream;
        boolean bl = false;
        if (this.zzd == null && this.zzg != null && (fileOutputStream = this.zza()) != null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(this.zzg.length);
                dataOutputStream.write(this.zzg);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                SafeBrowsingData.zza(dataOutputStream);
            }
        }
        if (!bl) {
            zzj.zza(this, parcel, n);
        } else {
            zzj.zza(this, parcel, n | 1);
        }
        this.zzd = null;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setTempDir(File file) {
        if (file != null) {
            this.zzh = file;
        }
    }

    private final FileOutputStream zza() {
        FileOutputStream fileOutputStream;
        if (this.zzh == null) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile("xlb", ".tmp", this.zzh);
            fileOutputStream = new FileOutputStream(file);
            this.zzd = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return fileOutputStream;
    }
}

