/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.safetynet;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.safetynet.zzj;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

@Hide
public class SafeBrowsingData
extends zzbgl {
    private static final String TAG = SafeBrowsingData.class.getSimpleName();
    public static final Parcelable.Creator<SafeBrowsingData> CREATOR = new zzj();
    private String zzkkd;
    private DataHolder zzkke;
    private ParcelFileDescriptor zzcup;
    private long zzddi;
    private byte[] zzkkf;
    private byte[] zzkkg;
    private File zzgcd;

    public SafeBrowsingData(String string, DataHolder dataHolder, ParcelFileDescriptor parcelFileDescriptor, long l, byte[] byArray) {
        this.zzkkd = string;
        this.zzkke = dataHolder;
        this.zzcup = parcelFileDescriptor;
        this.zzddi = l;
        this.zzkkf = byArray;
    }

    public SafeBrowsingData(String string) {
        this(string, null, null, 0L, null);
    }

    public SafeBrowsingData(String string, DataHolder dataHolder) {
        this(string, dataHolder, null, 0L, null);
    }

    public SafeBrowsingData(long l, byte[] byArray) {
        this(null, null, null, l, byArray);
    }

    public SafeBrowsingData() {
        this(null, null, null, 0L, null);
    }

    public String getMetadata() {
        return this.zzkkd;
    }

    public DataHolder getBlacklistsDataHolder() {
        return this.zzkke;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.zzcup;
    }

    public long getLastUpdateTimeMs() {
        return this.zzddi;
    }

    public byte[] getState() {
        return this.zzkkf;
    }

    public void setBlacklists(byte[] byArray) {
        this.zzkkg = byArray;
    }

    public byte[] getBlacklists() {
        if (this.zzcup == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcup));
        try {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            SafeBrowsingData.zza(dataInputStream);
            this.zzcup = null;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        FileOutputStream fileOutputStream;
        boolean bl = false;
        if (this.zzcup == null && this.zzkkg != null && (fileOutputStream = this.zzalg()) != null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(this.zzkkg.length);
                dataOutputStream.write(this.zzkkg);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                SafeBrowsingData.zza(dataOutputStream);
            }
        }
        if (!bl) {
            zzj.zza(this, parcel, n);
        } else {
            zzj.zza(this, parcel, n | 1);
        }
        this.zzcup = null;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setTempDir(File file) {
        if (file != null) {
            this.zzgcd = file;
        }
    }

    private final FileOutputStream zzalg() {
        FileOutputStream fileOutputStream;
        if (this.zzgcd == null) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile("xlb", ".tmp", this.zzgcd);
            fileOutputStream = new FileOutputStream(file);
            this.zzcup = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return fileOutputStream;
    }
}

