/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.safetynet;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.internal.safetynet.zzl;
import com.google.android.gms.internal.safetynet.zzm;
import com.google.android.gms.internal.safetynet.zzn;
import com.google.android.gms.internal.safetynet.zzo;
import com.google.android.gms.internal.safetynet.zzp;
import com.google.android.gms.internal.safetynet.zzq;
import com.google.android.gms.internal.safetynet.zzr;
import com.google.android.gms.internal.safetynet.zzs;
import com.google.android.gms.internal.safetynet.zzt;
import com.google.android.gms.internal.safetynet.zzu;
import com.google.android.gms.internal.safetynet.zzv;
import com.google.android.gms.internal.safetynet.zzw;
import com.google.android.gms.safetynet.HarmfulAppsData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzk
implements SafetyNetApi {
    private static final String TAG = zzk.class.getSimpleName();

    @Override
    public PendingResult<SafetyNetApi.zza> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzk.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.zza> zza(GoogleApiClient googleApiClient, byte[] byArray, String string) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzl(googleApiClient, byArray, string));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        String string2 = string;
        List<Integer> list2 = list;
        GoogleApiClient googleApiClient2 = googleApiClient;
        zzk zzk2 = this;
        if (list2 == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient2.enqueue((BaseImplementation.ApiMethodImpl)new zzm(zzk2, googleApiClient2, list2, string2, null));
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzk.zza(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzn(googleApiClient, nArray, n, string, string2));
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        GoogleApiClient googleApiClient = new GoogleApiClient.Builder(context).addApi(SafetyNet.API).build();
        try {
            if (googleApiClient.blockingConnect(3L, TimeUnit.SECONDS).isSuccess()) {
                SafetyNetApi.zzc zzc2 = (SafetyNetApi.zzc)this.isVerifyAppsEnabled(googleApiClient).await(3L, TimeUnit.SECONDS);
                boolean bl = zzc2 != null && zzc2.isVerifyAppsEnabled();
                return bl;
            }
            return false;
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
    }

    @Override
    public PendingResult<SafetyNetApi.zzc> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzo(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.zzc> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzp(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.zzb> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzq(this, googleApiClient));
    }

    @Override
    public PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzr(this, googleApiClient, string));
    }

    static final class zzh
    implements SafetyNetApi.RecaptchaTokenResult {
        private final Status zzad;
        private final com.google.android.gms.safetynet.zzf zzam;

        public zzh(Status status, com.google.android.gms.safetynet.zzf zzf2) {
            this.zzad = status;
            this.zzam = zzf2;
        }

        public final Status getStatus() {
            return this.zzad;
        }

        @Override
        public final String getTokenResult() {
            if (this.zzam == null) {
                return null;
            }
            return this.zzam.getTokenResult();
        }
    }

    static abstract class zze
    extends com.google.android.gms.internal.safetynet.zzf<SafetyNetApi.RecaptchaTokenResult> {
        protected com.google.android.gms.internal.safetynet.zzg zzaf = new zzv(this);

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new zzh(status2, null);
        }
    }

    static abstract class zzd
    extends com.google.android.gms.internal.safetynet.zzf<SafetyNetApi.zzb> {
        protected final com.google.android.gms.internal.safetynet.zzg zzaf = new zzu(this);

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new zzg(status2, null);
        }
    }

    static final class zzg
    implements SafetyNetApi.zzb {
        private final Status zzad;
        private final com.google.android.gms.safetynet.zzd zzal;

        public zzg(Status status, com.google.android.gms.safetynet.zzd zzd2) {
            this.zzad = status;
            this.zzal = zzd2;
        }

        @Override
        public final List<HarmfulAppsData> getHarmfulAppsList() {
            if (this.zzal == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.zzal.zzg);
        }

        @Override
        public final long getLastScanTimeMs() {
            if (this.zzal == null) {
                return 0L;
            }
            return this.zzal.zzf;
        }

        @Override
        public final int getHoursSinceLastScanWithHarmfulApp() {
            if (this.zzal == null) {
                return -1;
            }
            return this.zzal.zzh;
        }

        public final Status getStatus() {
            return this.zzad;
        }
    }

    static abstract class zzc
    extends com.google.android.gms.internal.safetynet.zzf<SafetyNetApi.zzc> {
        protected com.google.android.gms.internal.safetynet.zzg zzaf = new zzt(this);

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new zzj(status2, false);
        }
    }

    static final class zzj
    implements SafetyNetApi.zzc {
        private Status zzad;
        private boolean zzao;

        public zzj() {
        }

        public zzj(Status status, boolean bl) {
            this.zzad = status;
            this.zzao = bl;
        }

        @Override
        public final boolean isVerifyAppsEnabled() {
            if (this.zzad != null && this.zzad.isSuccess()) {
                return this.zzao;
            }
            return false;
        }

        public final Status getStatus() {
            return this.zzad;
        }
    }

    public static final class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status zzad;
        private final SafeBrowsingData zzan;
        private String zzm;
        private long zzp;
        private byte[] zzq;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.zzad = status;
            this.zzan = safeBrowsingData;
            this.zzm = null;
            if (this.zzan != null) {
                this.zzm = this.zzan.getMetadata();
                this.zzp = this.zzan.getLastUpdateTimeMs();
                this.zzq = this.zzan.getState();
                return;
            }
            if (this.zzad.isSuccess()) {
                this.zzad = new Status(8);
            }
        }

        public final Status getStatus() {
            return this.zzad;
        }

        @Override
        public final String getMetadata() {
            return this.zzm;
        }

        @Override
        public final long getLastUpdateTimeMs() {
            return this.zzp;
        }

        @Override
        public final byte[] getState() {
            return this.zzq;
        }

        @Override
        public final List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzm == null) {
                return arrayList;
            }
            try {
                jSONArray = new JSONObject(this.zzm).getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    int n = Integer.parseInt(jSONArray.getJSONObject(i).getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends com.google.android.gms.internal.safetynet.zzf<SafetyNetApi.SafeBrowsingResult> {
        protected com.google.android.gms.internal.safetynet.zzg zzaf = new zzw(this);

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new zzi(status2, null);
        }
    }

    static final class zza
    implements SafetyNetApi.zza {
        private final Status zzad;
        private final com.google.android.gms.safetynet.zza zzae;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.zzad = status;
            this.zzae = zza2;
        }

        public final Status getStatus() {
            return this.zzad;
        }

        @Override
        public final String getJwsResult() {
            if (this.zzae == null) {
                return null;
            }
            return this.zzae.getJwsResult();
        }
    }

    static abstract class zzb
    extends com.google.android.gms.internal.safetynet.zzf<SafetyNetApi.zza> {
        protected com.google.android.gms.internal.safetynet.zzg zzaf = new zzs(this);

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new zza(status2, null);
        }
    }
}

