/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.safetynet;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.safetynet.zzj;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="SafeBrowsingDataCreator")
public class SafeBrowsingData
extends AbstractSafeParcelable {
    private static final String TAG = SafeBrowsingData.class.getSimpleName();
    public static final Parcelable.Creator<SafeBrowsingData> CREATOR = new zzj();
    @SafeParcelable.Field(id=2, getter="getMetadata")
    private String zzm;
    @SafeParcelable.Field(id=3, getter="getBlacklistsDataHolder")
    private DataHolder zzn;
    @SafeParcelable.Field(id=4, getter="getFileDescriptor")
    private ParcelFileDescriptor zzo;
    @SafeParcelable.Field(id=5, getter="getLastUpdateTimeMs")
    private long zzp;
    @SafeParcelable.Field(id=6, getter="getState")
    private byte[] zzq;
    private byte[] zzr;
    private File zzs;

    @SafeParcelable.Constructor
    public SafeBrowsingData(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) DataHolder dataHolder, @SafeParcelable.Param(id=4) ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=5) long l, @SafeParcelable.Param(id=6) byte[] byArray) {
        this.zzm = string;
        this.zzn = dataHolder;
        this.zzo = parcelFileDescriptor;
        this.zzp = l;
        this.zzq = byArray;
    }

    public SafeBrowsingData(String string) {
        this(string, null, null, 0L, null);
    }

    public SafeBrowsingData(String string, DataHolder dataHolder) {
        this(string, dataHolder, null, 0L, null);
    }

    public SafeBrowsingData(long l, byte[] byArray) {
        this(null, null, null, l, byArray);
    }

    public SafeBrowsingData() {
        this(null, null, null, 0L, null);
    }

    public String getMetadata() {
        return this.zzm;
    }

    public DataHolder getBlacklistsDataHolder() {
        return this.zzn;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.zzo;
    }

    public long getLastUpdateTimeMs() {
        return this.zzp;
    }

    public byte[] getState() {
        return this.zzq;
    }

    public void setBlacklists(byte[] byArray) {
        this.zzr = byArray;
    }

    public byte[] getBlacklists() {
        if (this.zzo == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzo));
        try {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            SafeBrowsingData.zza(dataInputStream);
            this.zzo = null;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        FileOutputStream fileOutputStream;
        boolean bl = false;
        if (this.zzo == null && this.zzr != null && (fileOutputStream = this.zza()) != null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(this.zzr.length);
                dataOutputStream.write(this.zzr);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                SafeBrowsingData.zza(dataOutputStream);
            }
        }
        if (!bl) {
            zzj.zza(this, parcel, n);
        } else {
            zzj.zza(this, parcel, n | 1);
        }
        this.zzo = null;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setTempDir(File file) {
        if (file != null) {
            this.zzs = file;
        }
    }

    private final FileOutputStream zza() {
        FileOutputStream fileOutputStream;
        if (this.zzs == null) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile("xlb", ".tmp", this.zzs);
            fileOutputStream = new FileOutputStream(file);
            this.zzo = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return fileOutputStream;
    }
}

