/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.stats.netstats;

import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.stats.internal.G;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetstatsParserPatterns {
    public static final String IDENTS_PATTERN = " *ident=\\[(?<idents>.*)\\](?: uid=(?<uid>-?[0-9]+))?(?: set=(?<set>\\w+))?(?: tag=0x(?<tag>[0-9a-f]+))?.*";
    public static final String OLD_IDENT_PATTERN = "\\[(?:type=(?<type>-1|\\w+))[, ]*(?:subType=(?<subtype>[^,]+))?[, ]*(?:subscriberId=(?<subscriberId>[0-9]+)(?:...)?)?[, ]*(?<roaming>ROAMING)?[^]]*\\]";
    public static final String NEW_IDENT_PATTERN = "[\\[{](?:type=(?<type>-1|\\w+))[, ]*(?:subType=(?<subtype>[^,]+))?[, ]*(?:subscriberId=(?<subscriberId>[0-9]+)(?:...)?)?[, ]*(?<roaming>ROAMING)?[^\\]}]*[\\]}]";
    public static final String IDENT_PATTERN = PlatformVersion.isAtLeastLollipopMR1() ? "[\\[{](?:type=(?<type>-1|\\w+))[, ]*(?:subType=(?<subtype>[^,]+))?[, ]*(?:subscriberId=(?<subscriberId>[0-9]+)(?:...)?)?[, ]*(?<roaming>ROAMING)?[^\\]}]*[\\]}]" : "\\[(?:type=(?<type>-1|\\w+))[, ]*(?:subType=(?<subtype>[^,]+))?[, ]*(?:subscriberId=(?<subscriberId>[0-9]+)(?:...)?)?[, ]*(?<roaming>ROAMING)?[^]]*\\]";
    public static final String HISTORY_PATTERN = ".*bucketDuration=(?<duration>[0-9]+).*";
    public static final String OLD_BUCKET_PATTERN = " *bucketStart=(?<start>[0-9]+)(?: activeTime=(?<active>[0-9]+))?(?: rxBytes=(?<rxBytes>[0-9]+))?(?: rxPackets=(?<rxPackets>[0-9]+))?(?: txBytes=(?<txBytes>[0-9]+))?(?: txPackets=(?<txPackets>[0-9]+))?(?: operations=(?<operations>[0-9]+))?.*";
    public static final String NEW_BUCKET_PATTERN = " *st=(?<start>[0-9]+)(?: rb=(?<rxBytes>[0-9]+))?(?: rp=(?<rxPackets>[0-9]+))?(?: tb=(?<txBytes>[0-9]+))?(?: tp=(?<txPackets>[0-9]+))?(?: op=(?<operations>[0-9]+))?.*";
    public static final String BUCKET_PATTERN = PlatformVersion.isAtLeastLollipopMR1() ? " *st=(?<start>[0-9]+)(?: rb=(?<rxBytes>[0-9]+))?(?: rp=(?<rxPackets>[0-9]+))?(?: tb=(?<txBytes>[0-9]+))?(?: tp=(?<txPackets>[0-9]+))?(?: op=(?<operations>[0-9]+))?.*" : " *bucketStart=(?<start>[0-9]+)(?: activeTime=(?<active>[0-9]+))?(?: rxBytes=(?<rxBytes>[0-9]+))?(?: rxPackets=(?<rxPackets>[0-9]+))?(?: txBytes=(?<txBytes>[0-9]+))?(?: txPackets=(?<txPackets>[0-9]+))?(?: operations=(?<operations>[0-9]+))?.*";
    public static final String UID_STATS_START_PATTERN = "UID stats:|Detailed UID stats:";
    public static final String UID_TAG_STATS_START_PATTERN = "UID tag stats:";
    public static final String TYPE_BOTH_PATTERN = "ALL";
    public static final String TYPE_BACKGROUND_PATTERN = "DEFAULT";
    public static final String TYPE_FOREGROUND_PATTERN = "FOREGROUND";
    public static final String TYPE_DEBUG_VPN_IN_PATTERN = "DBG_VPN_IN";
    public static final String TYPE_DEBUG_VPN_OUT_PATTERN = "DBG_VPN_OUT";
    public static final int OLD_TS_TO_MILLIS = 1;
    public static final int NEW_TS_TO_MILLIS = 1000;
    public static final int TS_TO_MILLIS = PlatformVersion.isAtLeastLollipopMR1() ? 1000 : 1;
    private Pattern zzaen;
    private Map<String, Integer> zzaeo;
    private Pattern zzaep;
    private Map<String, Integer> zzaeq;
    private Pattern zzaer;
    private Map<String, Integer> zzaes;
    private Pattern zzaet;
    private Map<String, Integer> zzaeu;
    private Pattern zzaev;
    private Pattern zzaew;
    private Pattern zzaex;
    private Pattern zzaey;
    private Pattern zzaez;
    private Pattern zzafa;
    private Pattern zzafb;
    private int zzafc;
    private int zzafd;
    private static final Pattern zzafe = Pattern.compile("\\?<([a-zA-Z0-9]+)>");

    public NetstatsParserPatterns() {
        String string = (String)G.netStats.patterns.IDENTS.getBinderSafe();
        this.zzaen = NetstatsParserPatterns.zzp(string);
        this.zzaeo = NetstatsParserPatterns.zzo(string);
        String string2 = (String)G.netStats.patterns.IDENT.getBinderSafe();
        this.zzaep = NetstatsParserPatterns.zzp(string2);
        this.zzaeq = NetstatsParserPatterns.zzo(string2);
        String string3 = (String)G.netStats.patterns.HISTORY.getBinderSafe();
        this.zzaer = NetstatsParserPatterns.zzp(string3);
        this.zzaes = NetstatsParserPatterns.zzo(string3);
        String string4 = (String)G.netStats.patterns.BUCKET.getBinderSafe();
        this.zzaet = NetstatsParserPatterns.zzp(string4);
        this.zzaeu = NetstatsParserPatterns.zzo(string4);
        this.zzaev = Pattern.compile((String)G.netStats.patterns.UID_STATS_START.getBinderSafe());
        this.zzaew = Pattern.compile((String)G.netStats.patterns.UID_TAG_STATS_START.getBinderSafe());
        this.zzaex = Pattern.compile((String)G.netStats.patterns.TYPE_BOTH.getBinderSafe());
        this.zzaey = Pattern.compile((String)G.netStats.patterns.TYPE_BACKGROUND.getBinderSafe());
        this.zzaez = Pattern.compile((String)G.netStats.patterns.TYPE_FOREGROUND.getBinderSafe());
        this.zzafa = Pattern.compile((String)G.netStats.patterns.TYPE_DEBUG_VPN_IN_PATTERN.getBinderSafe());
        this.zzafb = Pattern.compile((String)G.netStats.patterns.TYPE_DEBUG_VPN_OUT_PATTERN.getBinderSafe());
        this.zzafc = (Integer)G.netStats.patterns.TAG_RADIX.getBinderSafe();
        this.zzafd = (Integer)G.netStats.patterns.TS_TO_MILLIS.getBinderSafe();
    }

    private static Map<String, Integer> zzo(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Matcher matcher = zzafe.matcher(string);
        int n = 1;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            hashMap.put(string2, n);
            ++n;
        }
        return hashMap;
    }

    private static Pattern zzp(String string) {
        return Pattern.compile(zzafe.matcher(string).replaceAll(""));
    }

    public NetstatsMatcher idents(String string) {
        return new NetstatsMatcher(this.zzaen.matcher(string), this.zzaeo);
    }

    public NetstatsMatcher ident(String string) {
        return new NetstatsMatcher(this.zzaep.matcher(string), this.zzaeq);
    }

    public NetstatsMatcher history(String string) {
        return new NetstatsMatcher(this.zzaer.matcher(string), this.zzaes);
    }

    public NetstatsMatcher bucket(String string) {
        return new NetstatsMatcher(this.zzaet.matcher(string), this.zzaeu);
    }

    public boolean isUidStart(String string) {
        return this.zzaev.matcher(string).matches();
    }

    public boolean isUidTagStart(String string) {
        return this.zzaew.matcher(string).matches();
    }

    public boolean isTypeBoth(String string) {
        return this.zzaex.matcher(string).matches();
    }

    public boolean isTypeBackground(String string) {
        return this.zzaey.matcher(string).matches();
    }

    public boolean isTypeForeground(String string) {
        return this.zzaez.matcher(string).matches();
    }

    public boolean isTypeDebugVpn(String string) {
        return this.zzafa.matcher(string).matches() || this.zzafb.matcher(string).matches();
    }

    public int tagRadix() {
        return this.zzafc;
    }

    public long toMillis(long l) {
        return l * (long)this.zzafd;
    }

    public static class NetstatsMatcher {
        private Matcher zzaff;
        private Map<String, Integer> zzafg;

        public NetstatsMatcher(Matcher matcher, Map<String, Integer> map) {
            this.zzaff = matcher;
            this.zzafg = map;
        }

        public boolean matches() {
            return this.zzaff.matches();
        }

        public boolean find() {
            return this.zzaff.find();
        }

        public String get(String string) {
            if (!this.zzafg.containsKey(string)) {
                String string2 = String.valueOf(string);
                throw new IllegalArgumentException(string2.length() != 0 ? "Unknown group ".concat(string2) : new String("Unknown group "));
            }
            return this.zzaff.group(this.zzafg.get(string));
        }
    }
}

