/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.stats;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.providers.PooledExecutorsProvider;
import com.google.android.gms.common.stats.StatsUtils;
import com.google.android.gms.common.stats.WakeLockTracker;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.stats.zza;
import com.google.android.gms.stats.zzb;
import com.google.android.gms.stats.zzc;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WakeLock {
    private final PowerManager.WakeLock zzadv;
    private WorkSource zzadw;
    private String zzadx;
    private final int zzady;
    private final String zzadz;
    private final String zzaea;
    private final String zzaeb;
    private final Context zzjp;
    private boolean zzaec = true;
    private final Map<String, Integer[]> zzaed = new HashMap<String, Integer[]>();
    private int zzaee;
    private AtomicInteger zzaef = new AtomicInteger(0);
    private static ScheduledExecutorService zzaeg;
    private static Configuration zzaeh;

    public WakeLock(Context context, int n, @Nonnull String string) {
        this(context, n, string, null, context == null ? null : context.getPackageName());
    }

    public WakeLock(Context context, int n, @Nonnull String string, @Nullable String string2) {
        this(context, n, string, string2, context == null ? null : context.getPackageName());
    }

    @SuppressLint(value={"UnwrappedWakeLock"})
    public WakeLock(Context context, int n, @Nonnull String string, @Nullable String string2, @Nonnull String string3) {
        this(context, n, string, string2, string3, null);
    }

    @SuppressLint(value={"UnwrappedWakeLock"})
    public WakeLock(Context context, int n, @Nonnull String string, @Nullable String string2, @Nonnull String string3, @Nullable String string4) {
        Preconditions.checkNotEmpty((String)string, (Object)"Wake lock name can NOT be empty");
        this.zzady = n;
        this.zzaea = string2;
        this.zzaeb = string4;
        this.zzjp = context.getApplicationContext();
        if (!"com.google.android.gms".equals(context.getPackageName())) {
            String string5 = String.valueOf("*gcore*:");
            String string6 = String.valueOf(string);
            this.zzadz = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        } else {
            this.zzadz = string;
        }
        this.zzadv = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string);
        if (WorkSourceUtil.hasWorkSourcePermission((Context)context)) {
            String string7 = Strings.isEmptyOrWhitespace((String)string3) ? context.getPackageName() : string3;
            String string8 = string4;
            String string9 = string7;
            Context context2 = context;
            WakeLock wakeLock = this;
            if (zzaeh.isWorkChainsEnabled() && string9 != null && string8 != null) {
                Log.d((String)"WakeLock", (String)new StringBuilder(42 + String.valueOf(string9).length() + String.valueOf(string8).length()).append("Using experimental Pi WorkSource chains: ").append(string9).append(",").append(string8).toString());
                wakeLock.zzadx = string9;
                wakeLock.zzadw = WorkSourceUtil.fromPackageAndModuleExperimentalPi((Context)context2, (String)string9, (String)string8);
            } else {
                wakeLock.zzadw = WorkSourceUtil.fromPackage((Context)context2, (String)string9);
            }
            this.addWorkSource(this.zzadw);
        }
        if (zzaeg == null) {
            zzaeg = PooledExecutorsProvider.getInstance().newSingleThreadScheduledExecutor();
        }
    }

    private final List<String> zzdo() {
        ArrayList<String> arrayList = WorkSourceUtil.getNames((WorkSource)this.zzadw);
        if (this.zzadx == null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>(arrayList);
        arrayList.add(this.zzadx);
        return arrayList;
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.zzadv;
    }

    public void acquire() {
        this.zzaef.incrementAndGet();
        this.zza(null, 0L);
    }

    public void acquire(long l) {
        this.zzaef.incrementAndGet();
        this.zza(null, l);
    }

    public void acquire(String string) {
        this.zzaef.incrementAndGet();
        this.zza(string, 0L);
    }

    public void acquire(String string, long l) {
        this.zzaef.incrementAndGet();
        this.zza(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"WakelockTimeout"})
    private final void zza(String string, long l) {
        WakeLock wakeLock;
        block13: {
            long l2 = l;
            String string2 = string;
            wakeLock = this;
            String string3 = wakeLock.zzn(string2);
            WakeLock wakeLock2 = wakeLock;
            synchronized (wakeLock2) {
                block12: {
                    block11: {
                        boolean bl;
                        if (!(wakeLock.zzaed.isEmpty() && wakeLock.zzaee <= 0 || wakeLock.zzadv.isHeld())) {
                            wakeLock.zzaed.clear();
                            wakeLock.zzaee = 0;
                        }
                        if (!wakeLock.zzaec) break block11;
                        String string4 = string3;
                        WakeLock wakeLock3 = wakeLock;
                        Integer[] integerArray = wakeLock3.zzaed.get(string4);
                        if (integerArray == null) {
                            wakeLock3.zzaed.put(string4, new Integer[]{1});
                            bl = true;
                        } else {
                            integerArray[0] = integerArray[0] + 1;
                            bl = false;
                        }
                        if (bl) break block12;
                    }
                    if (wakeLock.zzaec || wakeLock.zzaee != 0) break block13;
                }
                WakeLockTracker.getInstance().registerEvent(wakeLock.zzjp, StatsUtils.getEventKey((PowerManager.WakeLock)wakeLock.zzadv, (String)string3), 7, wakeLock.zzadz, string3, wakeLock.zzaeb, wakeLock.zzady, wakeLock.zzdo(), l2);
                ++wakeLock.zzaee;
            }
        }
        this.zzadv.acquire();
        if (l > 0L) {
            long l3 = l;
            wakeLock = this;
            zzaeg.schedule(new zzb(wakeLock), l3, TimeUnit.MILLISECONDS);
            if (!PlatformVersion.isAtLeastIceCreamSandwich() && this.zzaec) {
                String string5 = String.valueOf(this.zzadz);
                Log.wtf((String)"WakeLock", (String)(string5.length() != 0 ? "Do not acquire with timeout on reference counted wakeLocks before ICS. wakelock: ".concat(string5) : new String("Do not acquire with timeout on reference counted wakeLocks before ICS. wakelock: ")));
            }
        }
    }

    public HeldLock acquireLock(long l, String string) {
        String string2 = string;
        WakeLock wakeLock = this;
        long l2 = Math.min(l, zzaeh.getMaximumTimeout(wakeLock.zzadz, string2));
        HeldLock heldLock = wakeLock.new HeldLock(string2, null);
        wakeLock.zza(string2, 0L);
        WeakReference<HeldLock> weakReference = new WeakReference<HeldLock>(heldLock);
        heldLock.zzael = WakeLock.zzaeg.schedule(new zzc(weakReference), l2, TimeUnit.MILLISECONDS);
        return heldLock;
    }

    public void release() {
        this.zzb(null, 0);
    }

    public void release(int n) {
        this.zzb(null, n);
    }

    public void release(String string) {
        this.zzb(string, 0);
    }

    public void release(String string, int n) {
        this.zzb(string, n);
    }

    private final void zzb(String string, int n) {
        if (this.zzaef.decrementAndGet() < 0) {
            Log.e((String)"WakeLock", (String)"release without a matched acquire!");
        }
        this.zzc(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(String string, int n) {
        block12: {
            String string2 = string;
            WakeLock wakeLock = this;
            String string3 = wakeLock.zzn(string2);
            WakeLock wakeLock2 = wakeLock;
            synchronized (wakeLock2) {
                block11: {
                    block10: {
                        boolean bl;
                        if (!wakeLock.zzaec) break block10;
                        String string4 = string3;
                        WakeLock wakeLock3 = wakeLock;
                        Integer[] integerArray = wakeLock3.zzaed.get(string4);
                        if (integerArray == null) {
                            bl = false;
                        } else if (integerArray[0] == 1) {
                            wakeLock3.zzaed.remove(string4);
                            bl = true;
                        } else {
                            integerArray[0] = integerArray[0] - 1;
                            bl = false;
                        }
                        if (bl) break block11;
                    }
                    if (wakeLock.zzaec || wakeLock.zzaee != 1) break block12;
                }
                WakeLockTracker.getInstance().registerEvent(wakeLock.zzjp, StatsUtils.getEventKey((PowerManager.WakeLock)wakeLock.zzadv, (String)string3), 8, wakeLock.zzadz, string3, wakeLock.zzaeb, wakeLock.zzady, wakeLock.zzdo());
                --wakeLock.zzaee;
            }
        }
        this.zzn(n);
    }

    private final void zzn(int n) {
        if (this.zzadv.isHeld()) {
            try {
                if (Build.VERSION.SDK_INT >= 21 && n > 0) {
                    this.zzadv.release(n);
                    return;
                }
                this.zzadv.release();
                return;
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                if (runtimeException.getClass().equals(RuntimeException.class)) {
                    Log.e((String)"WakeLock", (String)String.valueOf(this.zzadz).concat(" was already released!"), (Throwable)runtimeException2);
                    return;
                }
                throw runtimeException2;
            }
        }
    }

    private final String zzn(String string) {
        if (this.zzaec) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return this.zzaea;
        }
        return this.zzaea;
    }

    public void setReferenceCounted(boolean bl) {
        this.zzadv.setReferenceCounted(bl);
        this.zzaec = bl;
    }

    public boolean isHeld() {
        return this.zzadv.isHeld();
    }

    public void addWorkSource(WorkSource workSource) {
        if (workSource != null && WorkSourceUtil.hasWorkSourcePermission((Context)this.zzjp)) {
            if (this.zzadw != null) {
                this.zzadw.add(workSource);
            } else {
                this.zzadw = workSource;
            }
            this.zza(this.zzadw);
        }
    }

    private final void zza(WorkSource workSource) {
        try {
            this.zzadv.setWorkSource(workSource);
            return;
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            Log.wtf((String)"WakeLock", (String)runtimeException.toString());
            return;
        }
    }

    public void removeWorkSource(WorkSource workSource) {
        if (workSource != null && WorkSourceUtil.hasWorkSourcePermission((Context)this.zzjp)) {
            try {
                if (this.zzadw != null) {
                    this.zzadw.remove(workSource);
                }
                this.zza(this.zzadw);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.e((String)"WakeLock", (String)arrayIndexOutOfBoundsException.toString());
            }
        }
    }

    public void setWorkSource(WorkSource workSource) {
        if (WorkSourceUtil.hasWorkSourcePermission((Context)this.zzjp)) {
            this.zza(workSource);
            this.zzadw = workSource;
            this.zzadx = null;
        }
    }

    public static void setConfiguration(Configuration configuration) {
        zzaeh = configuration;
    }

    static /* synthetic */ void zza(WakeLock wakeLock, int n) {
        wakeLock.zzn(0);
    }

    static {
        zzaeh = new zza();
    }

    public class HeldLock {
        private boolean zzaek = true;
        private Future zzael;
        private final String zzaem;

        private HeldLock(String string) {
            this.zzaem = string;
        }

        public void release() {
            this.release(0);
        }

        public synchronized void release(int n) {
            if (!this.zzaek) {
                return;
            }
            this.zzaek = false;
            if (this.zzael != null) {
                this.zzael.cancel(false);
                this.zzael = null;
            }
            WakeLock.this.zzc(this.zzaem, n);
        }

        public void finalize() {
            if (this.zzaek) {
                String string = String.valueOf(this.zzaem);
                Log.e((String)"WakeLock", (String)(string.length() != 0 ? "HeldLock finalized while still holding the WakeLock! Reason: ".concat(string) : new String("HeldLock finalized while still holding the WakeLock! Reason: ")));
                this.release(0);
            }
        }

        /* synthetic */ HeldLock(String string, zza zza2) {
            this(string);
        }
    }

    public static interface Configuration {
        public long getMaximumTimeout(String var1, String var2);

        public boolean isWorkChainsEnabled();
    }
}

