/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzaa;
import com.google.android.gms.tasks.zzu;
import com.google.android.gms.tasks.zzy;
import com.google.android.gms.tasks.zzz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public final class Tasks {
    @NonNull
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        zzu2.zza(TResult);
        return zzu2;
    }

    @NonNull
    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzu zzu2 = new zzu();
        zzu2.zza(exception);
        return zzu2;
    }

    @NonNull
    public static <TResult> Task<TResult> forCanceled() {
        zzu zzu2 = new zzu();
        zzu2.zza();
        return zzu2;
    }

    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull(callable, (Object)"Callback must not be null");
        zzu zzu2 = new zzu();
        executor.execute(new zzy(zzu2, callable));
        return zzu2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zza(task);
        }
        zzb zzb2 = new zzb(null);
        Tasks.zza(task, zzb2);
        zzb2.zza();
        return Tasks.zza(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zza(task);
        }
        zzb zzb2 = new zzb(null);
        Tasks.zza(task, zzb2);
        if (!zzb2.zza(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zza(task);
    }

    @NonNull
    public static Task<Void> whenAll(@Nullable Collection<? extends Task<?>> collection) {
        if (collection == null || collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzu();
        zzc zzc2 = new zzc(collection.size(), (zzu<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    @NonNull
    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@Nullable Collection<? extends Task<?>> collection) {
        if (collection == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAll(collection).continueWith(new zzaa(collection));
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@Nullable Collection<? extends Task<?>> collection) {
        if (collection == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAll(collection).continueWithTask(new zzz(collection));
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zza(@NonNull Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zza zza2) {
        task.addOnSuccessListener(TaskExecutors.zza, zza2);
        task.addOnFailureListener(TaskExecutors.zza, (OnFailureListener)zza2);
        task.addOnCanceledListener(TaskExecutors.zza, (OnCanceledListener)zza2);
    }

    private Tasks() {
    }

    private static final class zzc
    implements zza {
        private final Object zza = new Object();
        private final int zzb;
        private final zzu<Void> zzc;
        @GuardedBy(value="mLock")
        private int zzd;
        @GuardedBy(value="mLock")
        private int zze;
        @GuardedBy(value="mLock")
        private int zzf;
        @GuardedBy(value="mLock")
        private Exception zzg;
        @GuardedBy(value="mLock")
        private boolean zzh;

        public zzc(int n, zzu<Void> zzu2) {
            this.zzb = n;
            this.zzc = zzu2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.zza;
            synchronized (object) {
                ++this.zze;
                this.zzg = exception;
                this.zza();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.zza;
            synchronized (object2) {
                ++this.zzd;
                this.zza();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onCanceled() {
            Object object = this.zza;
            synchronized (object) {
                ++this.zzf;
                this.zzh = true;
                this.zza();
                return;
            }
        }

        @GuardedBy(value="mLock")
        private final void zza() {
            if (this.zzd + this.zze + this.zzf == this.zzb) {
                if (this.zzg != null) {
                    int n = this.zze;
                    int n2 = this.zzb;
                    this.zzc.zza(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzg));
                    return;
                }
                if (this.zzh) {
                    this.zzc.zza();
                    return;
                }
                this.zzc.zza((Void)null);
            }
        }
    }

    private static final class zzb
    implements zza {
        private final CountDownLatch zza = new CountDownLatch(1);

        private zzb() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zza.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zza.countDown();
        }

        @Override
        public final void onCanceled() {
            this.zza.countDown();
        }

        public final void zza() throws InterruptedException {
            this.zza.await();
        }

        public final boolean zza(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zza.await(l, timeUnit);
        }

        /* synthetic */ zzb(zzy zzy2) {
            this();
        }
    }

    static interface zza
    extends OnCanceledListener,
    OnFailureListener,
    OnSuccessListener<Object> {
    }
}

