/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.tasks.zza;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzaa;
import com.google.android.gms.tasks.zzab;
import com.google.android.gms.tasks.zzac;
import com.google.android.gms.tasks.zzad;
import com.google.android.gms.tasks.zzae;
import com.google.android.gms.tasks.zzb;
import com.google.android.gms.tasks.zzw;
import com.google.android.gms.tasks.zzx;
import com.google.android.gms.tasks.zzy;
import com.google.android.gms.tasks.zzz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        Callable<TResult> callable2;
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        Executor executor2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull((Object)var1_1, (Object)"Callback must not be null");
        zzw zzw2 = new zzw();
        executor2.execute(new zzz(zzw2, (Callable)var1_1));
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forCanceled() {
        zzw zzw2 = new zzw();
        zzw2.zzc();
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forException(@NonNull Exception e) {
        Exception exception;
        zzw zzw2 = new zzw();
        zzw2.zza(exception);
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forResult(TResult result) {
        TResult TResult;
        zzw zzw2 = new zzw();
        zzw2.zzb(TResult);
        return zzw2;
    }

    @NonNull
    public static Task<Void> whenAll(@Nullable Collection<? extends Task<?>> tasks) {
        Iterator<? extends Task<?>> iterator;
        if (tasks == null || iterator.isEmpty()) {
            return Tasks.forResult(null);
        }
        zzw<Void> zzw2 = iterator.iterator();
        while (zzw2.hasNext()) {
            if (zzw2.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        zzw2 = new zzw<Void>();
        zzae zzae2 = new zzae(iterator.size(), zzw2);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tasks.zzb((Task)iterator.next(), zzae2);
        }
        return zzw2;
    }

    @NonNull
    public static Task<Void> whenAll(Task<?> ... tasks) {
        Task<?>[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@Nullable Collection<? extends Task<?>> tasks) {
        Collection<? extends Task<?>> collection;
        return Tasks.whenAllComplete(TaskExecutors.MAIN_THREAD, collection);
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... tasks) {
        Task<?>[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@NonNull Executor executor, @Nullable Collection<? extends Task<?>> tasks) {
        Executor executor2;
        void var1_1;
        if (tasks == null || var1_1.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAll(var1_1).continueWithTask(executor2, new zzab((Collection)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@NonNull Executor executor, Task<?> ... tasks) {
        Executor executor2;
        void var1_1;
        if (tasks == null || ((void)var1_1).length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllComplete(executor2, Arrays.asList(var1_1));
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@Nullable Collection<? extends Task> tasks) {
        Collection<? extends Task> collection;
        return Tasks.whenAllSuccess(TaskExecutors.MAIN_THREAD, collection);
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(Task ... tasks) {
        Task[] taskArray;
        if (tasks == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@NonNull Executor executor, @Nullable Collection<? extends Task> tasks) {
        Executor executor2;
        void var1_1;
        if (tasks == null || var1_1.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAll(var1_1).continueWith(executor2, new zzaa((Collection)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@NonNull Executor executor, Task ... tasks) {
        Executor executor2;
        void var1_1;
        if (tasks == null || ((void)var1_1).length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllSuccess(executor2, Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public static <T> Task<T> withTimeout(@NonNull Task<T> task, long timeout, @NonNull TimeUnit unit) {
        Task<T> task2;
        void var3_2;
        void var1_1;
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        boolean bl = var1_1 > 0L;
        Preconditions.checkArgument((boolean)bl, (Object)"Timeout must be positive");
        Preconditions.checkNotNull((Object)var3_2, (Object)"TimeUnit must not be null");
        zzb zzb2 = new zzb();
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource(zzb2);
        zza zza2 = new zza(Looper.getMainLooper());
        zza2.postDelayed(new zzx(taskCompletionSource), var3_2.toMillis((long)var1_1));
        task2.addOnCompleteListener(new zzy(zza2, taskCompletionSource, zzb2));
        return taskCompletionSource.getTask();
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Task<TResult> task2;
        Preconditions.checkNotMainThread();
        Preconditions.checkNotGoogleApiHandlerThread();
        Preconditions.checkNotNull(task2, (Object)"Task must not be null");
        if (task2.isComplete()) {
            return (TResult)Tasks.zza(task2);
        }
        zzac zzac2 = new zzac(null);
        Tasks.zzb(task2, zzac2);
        zzac2.zza();
        return (TResult)Tasks.zza(task2);
    }

    /*
     * WARNING - void declaration
     */
    public static <TResult> TResult await(@NonNull Task<TResult> task, long timeout, @NonNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        void var3_2;
        Task<TResult> task2;
        Preconditions.checkNotMainThread();
        Preconditions.checkNotGoogleApiHandlerThread();
        Preconditions.checkNotNull(task2, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)var3_2, (Object)"TimeUnit must not be null");
        if (task2.isComplete()) {
            return (TResult)Tasks.zza(task2);
        }
        zzac zzac2 = new zzac(null);
        Tasks.zzb(task2, zzac2);
        if (!zzac2.zzb((long)var1_1, (TimeUnit)var3_2)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return (TResult)Tasks.zza(task2);
    }

    private Tasks() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Object zza(@NonNull Task task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        if (!task.isCanceled()) throw new ExecutionException(task.getException());
        throw new CancellationException("Task is already canceled");
    }

    private static void zzb(Task task, zzad zzad2) {
        task.addOnSuccessListener(TaskExecutors.zza, zzad2);
        task.addOnFailureListener(TaskExecutors.zza, (OnFailureListener)zzad2);
        task.addOnCanceledListener(TaskExecutors.zza, (OnCanceledListener)zzad2);
    }
}

