/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzh;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzh<TResult> zzh2 = new zzh<TResult>();
        zzh2.setResult(TResult);
        return zzh2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzh zzh2 = new zzh();
        zzh2.setException(exception);
        return zzh2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, final @NonNull Callable<TResult> callable) {
        zzaa.zzb((Object)executor, (Object)"Executor must not be null");
        zzaa.zzb(callable, (Object)"Callback must not be null");
        final zzh zzh2 = new zzh();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    zzh2.setResult(callable.call());
                }
                catch (Exception exception) {
                    zzh2.setException(exception);
                }
            }
        });
        return zzh2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzaa.zzawk();
        zzaa.zzb(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzb(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzaa.zzawk();
        zzaa.zzb(task, (Object)"Task must not be null");
        zzaa.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzb(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        Task<?> task2;
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        for (Task<?> task2 : collection) {
            if (task2 != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        zzh zzh2 = new zzh();
        task2 = new zzc(collection.size(), zzh2);
        for (Task<?> task3 : collection) {
            Tasks.zza(task3, (zzb)((Object)task2));
        }
        return zzh2;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzb(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.aMT, zzb2);
        task.addOnFailureListener(TaskExecutors.aMT, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    private static final class zzc
    implements zzb {
        private final Object zzako = new Object();
        private final int aMZ;
        private final zzh<Void> aMS;
        private int aNa;
        private int aNb;
        private Exception aMX;

        public zzc(int n, zzh<Void> zzh2) {
            this.aMZ = n;
            this.aMS = zzh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Exception exception) {
            Object object = this.zzako;
            synchronized (object) {
                ++this.aNb;
                this.aMX = exception;
                this.zzclj();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(Object object) {
            Object object2 = this.zzako;
            synchronized (object2) {
                ++this.aNa;
                this.zzclj();
            }
        }

        private void zzclj() {
            if (this.aNa + this.aNb == this.aMZ) {
                if (this.aMX == null) {
                    this.aMS.setResult(null);
                } else {
                    int n = this.aNb;
                    int n2 = this.aMZ;
                    this.aMS.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.aMX));
                }
            }
        }
    }

    private static final class zza
    implements zzb {
        private final CountDownLatch zzank = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public void onSuccess(Object object) {
            this.zzank.countDown();
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            this.zzank.countDown();
        }

        public void await() throws InterruptedException {
            this.zzank.await();
        }

        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zzank.await(l, timeUnit);
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

