/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzge;
import com.google.android.gms.internal.vision.zzhr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfh
extends zzef<Double>
implements zzge<Double>,
zzhr,
RandomAccess {
    private static final zzfh zztc = new zzfh();
    private double[] zztd;
    private int size;

    zzfh() {
        this(new double[10], 0);
    }

    private zzfh(double[] dArray, int n) {
        this.zztd = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztd, n2, this.zztd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfh)) {
            return super.equals(object);
        }
        zzfh zzfh2 = (zzfh)object;
        if (this.size != zzfh2.size) {
            return false;
        }
        double[] dArray = zzfh2.zztd;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zztd[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zztd[i]);
            n = n * 31 + zzga.zzo(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzcj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
        if (this.size < this.zztd.length) {
            System.arraycopy(this.zztd, n, this.zztd, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztd, 0, dArray, 0, n);
            System.arraycopy(this.zztd, n, dArray, n + 1, this.size - n);
            this.zztd = dArray;
        }
        this.zztd[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzcj();
        zzga.checkNotNull(collection);
        if (!(collection instanceof zzfh)) {
            return super.addAll(collection);
        }
        zzfh zzfh2 = (zzfh)collection;
        if (zzfh2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfh2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfh2.size;
        if (n > this.zztd.length) {
            this.zztd = Arrays.copyOf(this.zztd, n);
        }
        System.arraycopy(zzfh2.zztd, 0, this.zztd, this.size, zzfh2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztd[i])) continue;
            System.arraycopy(this.zztd, i + 1, this.zztd, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzfh zzfh2 = this;
        zzfh2.zzcj();
        zzfh2.zzaf(n);
        double d3 = zzfh2.zztd[n];
        zzfh2.zztd[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfh zzfh2 = this;
        zzfh2.zzcj();
        zzfh2.zzaf(n);
        double d = zzfh2.zztd[n];
        if (n < zzfh2.size - 1) {
            System.arraycopy(zzfh2.zztd, n + 1, zzfh2.zztd, n, zzfh2.size - n);
        }
        --zzfh2.size;
        ++zzfh2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzge zzah(int n) {
        int n2 = n;
        zzfh zzfh2 = this;
        if (n2 < zzfh2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfh(Arrays.copyOf(zzfh2.zztd, n2), zzfh2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfh zzfh2 = this;
        zzfh2.zzaf(n);
        return zzfh2.zztd[n];
    }

    static {
        zztc.zzci();
    }
}

