/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.vision.zzap;
import com.google.android.gms.internal.vision.zzar;
import com.google.android.gms.internal.vision.zzas;
import com.google.android.gms.internal.vision.zzat;
import com.google.android.gms.internal.vision.zzau;
import com.google.android.gms.internal.vision.zzbe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzaq
implements zzau {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzaq> zzfj = new ArrayMap();
    private final ContentResolver zzfk;
    private final Uri uri;
    private final ContentObserver zzfl = new zzas(this, null);
    private final Object zzfm = new Object();
    private volatile Map<String, String> zzfn;
    @GuardedBy(value="this")
    private final List<zzar> zzfo = new ArrayList<zzar>();
    private static final String[] zzfp = new String[]{"key", "value"};

    private zzaq(ContentResolver contentResolver, Uri uri) {
        this.zzfk = contentResolver;
        this.uri = uri;
        contentResolver.registerContentObserver(uri, false, this.zzfl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaq zza(ContentResolver contentResolver, Uri uri) {
        Class<zzaq> clazz = zzaq.class;
        synchronized (zzaq.class) {
            zzaq zzaq2 = zzfj.get(uri);
            if (zzaq2 == null) {
                try {
                    zzaq2 = new zzaq(contentResolver, uri);
                    zzfj.put(uri, zzaq2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzaq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> zzu() {
        Map<String, String> map = this.zzfn;
        if (map == null) {
            Object object = this.zzfm;
            synchronized (object) {
                map = this.zzfn;
                if (map == null) {
                    this.zzfn = map = this.zzw();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzv() {
        zzaq zzaq2;
        Object object = this.zzfm;
        synchronized (object) {
            this.zzfn = null;
            zzbe.zzab();
        }
        zzaq zzaq3 = zzaq2 = this;
        synchronized (zzaq2) {
            Iterator<zzar> iterator = zzaq2.zzfo.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzz();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zzw() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzat.zza(new zzap(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzx() {
        for (zzaq zzaq2 : zzfj.values()) {
            zzaq2.zzfk.unregisterContentObserver(zzaq2.zzfl);
        }
        zzfj.clear();
    }

    @Override
    public final /* synthetic */ Object zzb(String string) {
        String string2 = string;
        return this.zzu().get(string2);
    }

    final /* synthetic */ Map zzy() {
        Cursor cursor = this.zzfk.query(this.uri, zzfp, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

