/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfc;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzit;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfk
extends zzfc<Boolean>
implements zzhe<Boolean>,
zzit,
RandomAccess {
    private static final zzfk zzsh = new zzfk(new boolean[0], 0);
    private boolean[] zzsi;
    private int size;

    zzfk() {
        this(new boolean[10], 0);
    }

    private zzfk(boolean[] blArray, int n) {
        this.zzsi = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdr();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsi, n2, this.zzsi, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfk)) {
            return super.equals(object);
        }
        zzfk zzfk2 = (zzfk)object;
        if (this.size != zzfk2.size) {
            return false;
        }
        boolean[] blArray = zzfk2.zzsi;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsi[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgy.zzm(this.zzsi[i]);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Boolean)) {
            return -1;
        }
        boolean bl = (Boolean)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzsi[i] != bl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzdr();
        if (this.size == this.zzsi.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsi, 0, blArray, 0, this.size);
            this.zzsi = blArray;
        }
        this.zzsi[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzdr();
        zzgy.checkNotNull(collection);
        if (!(collection instanceof zzfk)) {
            return super.addAll(collection);
        }
        zzfk zzfk2 = (zzfk)collection;
        if (zzfk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfk2.size;
        if (n > this.zzsi.length) {
            this.zzsi = Arrays.copyOf(this.zzsi, n);
        }
        System.arraycopy(zzfk2.zzsi, 0, this.zzsi, this.size, zzfk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdr();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsi[i])) continue;
            System.arraycopy(this.zzsi, i + 1, this.zzsi, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzfk zzfk2 = this;
        zzfk2.zzdr();
        zzfk2.zzaf(n);
        boolean bl3 = zzfk2.zzsi[n];
        zzfk2.zzsi[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfk zzfk2 = this;
        zzfk2.zzdr();
        zzfk2.zzaf(n);
        boolean bl = zzfk2.zzsi[n];
        if (n < zzfk2.size - 1) {
            System.arraycopy(zzfk2.zzsi, n + 1, zzfk2.zzsi, n, zzfk2.size - n - 1);
        }
        --zzfk2.size;
        ++zzfk2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzfk zzfk2 = this;
        zzfk2.zzdr();
        if (n < 0 || n > zzfk2.size) {
            throw new IndexOutOfBoundsException(zzfk2.zzag(n));
        }
        if (zzfk2.size < zzfk2.zzsi.length) {
            System.arraycopy(zzfk2.zzsi, n, zzfk2.zzsi, n + 1, zzfk2.size - n);
        } else {
            boolean[] blArray = new boolean[zzfk2.size * 3 / 2 + 1];
            System.arraycopy(zzfk2.zzsi, 0, blArray, 0, n);
            System.arraycopy(zzfk2.zzsi, n, blArray, n + 1, zzfk2.size - n);
            zzfk2.zzsi = blArray;
        }
        zzfk2.zzsi[n] = bl2;
        ++zzfk2.size;
        ++zzfk2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Boolean bl = (Boolean)object;
        this.addBoolean(bl);
        return true;
    }

    @Override
    public final /* synthetic */ zzhe zzah(int n) {
        int n2 = n;
        zzfk zzfk2 = this;
        if (n2 < zzfk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfk(Arrays.copyOf(zzfk2.zzsi, n2), zzfk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfk zzfk2 = this;
        zzfk2.zzaf(n);
        return zzfk2.zzsi[n];
    }

    static {
        zzsh.zzdq();
    }
}

