/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.vision.zzbq;
import com.google.android.gms.internal.vision.zzbv;
import com.google.android.gms.internal.vision.zzbw;
import com.google.android.gms.internal.vision.zzcc;
import com.google.android.gms.internal.vision.zzce;
import com.google.android.gms.internal.vision.zzcj;
import com.google.android.gms.internal.vision.zzcn;
import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzgj;
import com.google.android.gms.internal.vision.zzgx;
import com.google.android.gms.internal.vision.zzkk;
import com.google.android.gms.internal.vision.zzks;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.vision.clearcut.DynamiteClearcutLogger;
import com.google.android.gms.vision.face.FaceDetectorV2Jni;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.LandmarkParcel;
import com.google.android.gms.vision.face.internal.client.zza;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzg;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

final class NativeFaceDetectorV2Impl
extends zzg {
    private static final GmsLogger zzcy = new GmsLogger("NativeFaceDetectorV2Imp", "");
    private final long zzcz;
    private final DynamiteClearcutLogger zzda;
    private final zzcc.zzd zzdb;
    private final FaceDetectorV2Jni zzdc;

    NativeFaceDetectorV2Impl(Context context, Context context2, DynamiteClearcutLogger dynamiteClearcutLogger, zzf zzf2, FaceDetectorV2Jni faceDetectorV2Jni) {
        zzf zzf3 = zzf2;
        zzcc.zzg zzg2 = (zzcc.zzg)((zzgx)zzcc.zzg.zzbw().zzj("models").zzgd());
        zzcc.zzd.zza zza2 = zzcc.zzd.zzbq().zza(zzcc.zze.zzbs().zzh(zzg2).zzi(zzg2).zzj(zzg2)).zza(zzcc.zza.zzbe().zzc(zzg2).zzd(zzg2)).zza(zzcc.zzf.zzbu().zzk(zzg2).zzl(zzg2).zzm(zzg2).zzn(zzg2)).zzd(zzf3.zzcv).zze(zzf3.trackingEnabled).zze(zzf3.proportionalMinFaceSize).zzf(true);
        switch (zzf3.mode) {
            case 1: {
                zza2.zzb(zzcn.zzlm);
                break;
            }
            case 0: {
                zza2.zzb(zzcn.zzll);
                break;
            }
            case 2: {
                zza2.zzb(zzcn.zzln);
            }
        }
        switch (zzf3.landmarkType) {
            case 1: {
                zza2.zzb(zzcj.zzlc);
                break;
            }
            case 0: {
                zza2.zzb(zzcj.zzlb);
                break;
            }
            case 2: {
                zza2.zzb(zzcj.zzld);
            }
        }
        switch (zzf3.zzcw) {
            case 1: {
                zza2.zzb(zzce.zzjg);
                break;
            }
            case 0: {
                zza2.zzb(zzce.zzjf);
            }
        }
        this.zzdb = (zzcc.zzd)((zzgx)zza2.zzgd());
        this.zzcz = faceDetectorV2Jni.zza(this.zzdb, context2.getAssets());
        this.zzda = dynamiteClearcutLogger;
        this.zzdc = faceDetectorV2Jni;
    }

    public final void zzn() throws RemoteException {
        this.zzdc.zza(this.zzcz);
    }

    private static zzbw zze(int n) {
        switch (n) {
            case 0: {
                return zzbw.zzhw;
            }
            case 1: {
                return zzbw.zzhz;
            }
            case 2: {
                return zzbw.zzhy;
            }
            case 3: {
                return zzbw.zzhx;
            }
        }
        throw new IllegalArgumentException("Unsupported rotation degree.");
    }

    public final FaceParcel[] zzc(IObjectWrapper iObjectWrapper, zzu zzu2) throws RemoteException {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzcc.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            zzbv.zza zza2 = zzbv.zzaj().zzj(zzu2.width).zzk(zzu2.height).zzb(NativeFaceDetectorV2Impl.zze(zzu2.rotation)).zzb(zzbq.zzhf);
            if (zzu2.zzaz > 0L) {
                zza2.zzc(zzu2.zzaz * 1000L);
            }
            zzbv zzbv2 = (zzbv)((zzgx)zza2.zzgd());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer, zzbv2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer.array(), zzbv2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zzdc.zza(this.zzcz, (byte[])objectArray, zzbv2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzdb.zzbp(), this.zzdb.zzbo());
            NativeFaceDetectorV2Impl.zza(this.zzda, zzu2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zzcy.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final FaceParcel[] zza(IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3, int n, int n2, int n3, int n4, int n5, int n6, zzu zzu2) {
        long l = SystemClock.elapsedRealtime();
        try {
            Object[] objectArray;
            zzcc.zzc zzc2;
            ByteBuffer byteBuffer = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            ByteBuffer byteBuffer2 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
            ByteBuffer byteBuffer3 = (ByteBuffer)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
            zzbv.zza zza2 = zzbv.zzaj().zzj(zzu2.width).zzk(zzu2.height).zzb(NativeFaceDetectorV2Impl.zze(zzu2.rotation));
            if (zzu2.zzaz > 0L) {
                zza2.zzc(zzu2.zzaz * 1000L);
            }
            zzbv zzbv2 = (zzbv)((zzgx)zza2.zzgd());
            if (byteBuffer.isDirect()) {
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, zzbv2);
            } else if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                objectArray = byteBuffer2 != null && byteBuffer2.hasArray() && byteBuffer2.arrayOffset() == 0 ? byteBuffer2.array() : null;
                byte[] byArray = byteBuffer3 != null && byteBuffer3.hasArray() && byteBuffer3.arrayOffset() == 0 ? byteBuffer3.array() : null;
                zzc2 = this.zzdc.zza(this.zzcz, byteBuffer.array(), (byte[])objectArray, byArray, n, n2, n3, n4, n5, n6, zzbv2);
            } else {
                objectArray = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray = new byte[byteBuffer2.remaining()];
                byteBuffer.get((byte[])objectArray);
                byte[] byArray2 = new byte[byteBuffer3.remaining()];
                byteBuffer.get((byte[])objectArray);
                zzc2 = this.zzdc.zza(this.zzcz, (byte[])objectArray, byArray, byArray2, n, n2, n3, n4, n5, n6, zzbv2);
            }
            objectArray = NativeFaceDetectorV2Impl.zza(zzc2, this.zzdb.zzbp(), this.zzdb.zzbo());
            NativeFaceDetectorV2Impl.zza(this.zzda, zzu2, (FaceParcel[])objectArray, null, SystemClock.elapsedRealtime() - l);
            return objectArray;
        }
        catch (Exception exception) {
            zzcy.e("NativeFaceDetectorV2Imp", "Native face detection v2 failed", (Throwable)exception);
            return new FaceParcel[0];
        }
    }

    public final boolean zzd(int n) throws RemoteException {
        return true;
    }

    private static FaceParcel[] zza(zzcc.zzc zzc2, zzce zzce2, zzcj zzcj2) {
        zzks zzks2 = zzc2.zzbm();
        FaceParcel[] faceParcelArray = new FaceParcel[zzks2.zzjm()];
        for (int i = 0; i < zzks2.zzjm(); ++i) {
            zza[] zzaArray;
            LandmarkParcel[] object32;
            LandmarkParcel[] landmarkParcelArray;
            Object object;
            zzgx zzgx2;
            int n;
            zza[] zzaArray2;
            List list;
            float f;
            zzkk zzkk2 = zzks2.zzcc(i);
            zzkk.zzb zzb2 = zzkk2.zzis();
            float f2 = zzb2.zzjd() + (zzb2.zzjf() - zzb2.zzjd()) / 2.0f;
            float f3 = zzb2.zzje() + (zzb2.zzjg() - zzb2.zzje()) / 2.0f;
            float f4 = zzb2.zzjf() - zzb2.zzjd();
            float f5 = zzb2.zzjg() - zzb2.zzje();
            float f6 = -1.0f;
            float f7 = -1.0f;
            float f8 = -1.0f;
            if (zzce2 == zzce.zzjg) {
                for (zzkk.zza zza2 : zzkk2.zziy()) {
                    if (zza2.getName().equals("joy")) {
                        f8 = zza2.getConfidence();
                        continue;
                    }
                    if (zza2.getName().equals("left_eye_closed")) {
                        f6 = 1.0f - zza2.getConfidence();
                        continue;
                    }
                    if (!zza2.getName().equals("right_eye_closed")) continue;
                    f7 = 1.0f - zza2.getConfidence();
                }
            }
            float f9 = f = zzkk2.zziu() ? zzkk2.getConfidence() : -1.0f;
            if (zzcj2 == zzcj.zzlc) {
                list = zzkk2.zzit();
                zzaArray2 = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    int n2;
                    int n3;
                    zzgx2 = (zzkk.zze)((Object)list.get(n));
                    zzkk.zze.zza zza3 = zzgx2.zzjk();
                    switch (zza3) {
                        case zzafg: {
                            n3 = 4;
                            break;
                        }
                        case zzafh: {
                            n3 = 10;
                            break;
                        }
                        case zzafn: {
                            n3 = 6;
                            break;
                        }
                        case zzafp: {
                            n3 = 0;
                            break;
                        }
                        case zzafq: {
                            n3 = 5;
                            break;
                        }
                        case zzafr: {
                            n3 = 11;
                            break;
                        }
                        case zzagg: {
                            n3 = 3;
                            break;
                        }
                        case zzagh: {
                            n3 = 9;
                            break;
                        }
                        case zzago: {
                            n3 = 1;
                            break;
                        }
                        case zzagp: {
                            n3 = 7;
                            break;
                        }
                        case zzagq: {
                            n3 = 2;
                            break;
                        }
                        case zzagr: {
                            n3 = 8;
                            break;
                        }
                        default: {
                            object = String.valueOf((Object)zza3);
                            zzcy.d("NativeFaceDetectorV2Imp", new StringBuilder(23 + String.valueOf(object).length()).append("Unknown landmark type: ").append((String)object).toString());
                            n3 = n2 = -1;
                        }
                    }
                    if (n3 < 0) continue;
                    zzaArray2.add(new LandmarkParcel(-1, zzgx2.getX(), zzgx2.getY(), n2));
                }
                landmarkParcelArray = zzaArray2.toArray(new LandmarkParcel[0]);
            } else {
                landmarkParcelArray = object32 = new LandmarkParcel[]{};
            }
            if (zzcj2 == zzcj.zzld) {
                list = (List)zzkk2.zzc((zzgj)zzcc.zzja);
                zzaArray2 = new zza[list.size()];
                for (n = 0; n < list.size(); ++n) {
                    int n4;
                    zzgx2 = (zzcc.zzb)((Object)list.get(n));
                    PointF[] pointFArray = new PointF[zzgx2.zzbi()];
                    for (int j = 0; j < zzgx2.zzbi(); ++j) {
                        object = zzgx2.zzbh().get(j);
                        pointFArray[j] = new PointF(((zzcc.zzb.zzb)((Object)object)).getX(), ((zzcc.zzb.zzb)((Object)object)).getY());
                    }
                    zzcc.zzb.zzc zzc3 = zzgx2.zzbg();
                    switch (zzc3) {
                        case zzjq: {
                            n4 = 1;
                            break;
                        }
                        case zzjr: {
                            n4 = 2;
                            break;
                        }
                        case zzjs: {
                            n4 = 3;
                            break;
                        }
                        case zzjt: {
                            n4 = 4;
                            break;
                        }
                        case zzju: {
                            n4 = 5;
                            break;
                        }
                        case zzjv: {
                            n4 = 6;
                            break;
                        }
                        case zzjw: {
                            n4 = 7;
                            break;
                        }
                        case zzjx: {
                            n4 = 8;
                            break;
                        }
                        case zzjy: {
                            n4 = 9;
                            break;
                        }
                        case zzjz: {
                            n4 = 10;
                            break;
                        }
                        case zzka: {
                            n4 = 11;
                            break;
                        }
                        case zzkb: {
                            n4 = 12;
                            break;
                        }
                        case zzkc: {
                            n4 = 13;
                            break;
                        }
                        case zzkd: {
                            n4 = 14;
                            break;
                        }
                        case zzke: {
                            n4 = 15;
                            break;
                        }
                        default: {
                            int n5 = zzc3.zzah();
                            zzcy.e("NativeFaceDetectorV2Imp", new StringBuilder(33).append("Unknown contour type: ").append(n5).toString());
                            n4 = -1;
                        }
                    }
                    zzaArray2[n] = new zza(pointFArray, n4);
                }
                zzaArray = zzaArray2;
            } else {
                zzaArray = new zza[]{};
            }
            zza[] zzaArray3 = zzaArray;
            faceParcelArray[i] = new FaceParcel(3, (int)zzkk2.zziz(), f2, f3, f4, f5, zzkk2.zziw(), -zzkk2.zziv(), zzkk2.zzix(), object32, f6, f7, f8, zzaArray3, f);
        }
        return faceParcelArray;
    }

    private static void zza(DynamiteClearcutLogger dynamiteClearcutLogger, zzu zzu2, FaceParcel[] faceParcelArray, @Nullable String string, long l) {
        if (zzu2.id > 2 && faceParcelArray.length == 0) {
            return;
        }
        long l2 = l;
        Object var9_6 = null;
        FaceParcel[] faceParcelArray2 = faceParcelArray;
        zzu zzu3 = zzu2;
        ArrayList<zzef.zzn> arrayList = new ArrayList<zzef.zzn>();
        FaceParcel[] faceParcelArray3 = faceParcelArray2;
        int n = faceParcelArray2.length;
        for (int i = 0; i < n; ++i) {
            FaceParcel faceParcel = faceParcelArray3[i];
            zzef.zzm zzm2 = (zzef.zzm)((zzgx)zzef.zzm.zzdf().zzz((int)(faceParcel.centerX - faceParcel.width / 2.0f)).zzaa((int)(faceParcel.centerY - faceParcel.height / 2.0f)).zzgd());
            zzef.zzm zzm3 = (zzef.zzm)((zzgx)zzef.zzm.zzdf().zzz((int)(faceParcel.centerX + faceParcel.width / 2.0f)).zzaa((int)(faceParcel.centerY - faceParcel.height / 2.0f)).zzgd());
            zzef.zzm zzm4 = (zzef.zzm)((zzgx)zzef.zzm.zzdf().zzz((int)(faceParcel.centerX + faceParcel.width / 2.0f)).zzaa((int)(faceParcel.centerY + faceParcel.height / 2.0f)).zzgd());
            zzef.zzm zzm5 = (zzef.zzm)((zzgx)zzef.zzm.zzdf().zzz((int)(faceParcel.centerX - faceParcel.width / 2.0f)).zzaa((int)(faceParcel.centerY + faceParcel.height / 2.0f)).zzgd());
            zzef.zzh zzh2 = (zzef.zzh)((zzgx)zzef.zzh.zzcv().zzj(faceParcel.zzdh).zzk(faceParcel.zzdi).zzl(faceParcel.zzdj).zzg(faceParcel.zzcm).zzh(faceParcel.zzcn).zzi(faceParcel.zzco).zzgd());
            arrayList.add((zzef.zzn)((zzgx)zzef.zzn.zzdh().zza(zzef.zzd.zzco().zzb(zzm2).zzb(zzm3).zzb(zzm4).zzb(zzm5)).zzab(faceParcel.id).zzb(zzh2).zzgd()));
        }
        zzu zzu4 = zzu3;
        ArrayList<zzef.zzn> arrayList2 = arrayList;
        String string2 = "face";
        String string3 = null;
        int n2 = faceParcelArray2.length;
        long l3 = l2;
        zzef.zzi.zza zza2 = zzef.zzi.zzcy();
        ArrayList<zzef.zzn> arrayList3 = arrayList2;
        String string4 = string2;
        String string5 = string3;
        int n3 = n2;
        long l4 = l3;
        zzef.zzf.zza zza3 = zzef.zzf.zzcr().zzp(string4).zzd(l4).zze((long)n3);
        zza3.zzc(arrayList3);
        if (string5 != null) {
            zza3.zzq(string5);
        }
        ArrayList<zzef.zzf> arrayList4 = new ArrayList<zzef.zzf>();
        arrayList4.add((zzef.zzf)((zzgx)zza3.zzgd()));
        zzu zzu5 = zzu4;
        zzef.zzi zzi2 = (zzef.zzi)((zzgx)zza2.zze(arrayList4).zza((zzef.zzj)((zzgx)zzef.zzj.zzda().zzi((long)zzu5.height).zzh((long)zzu5.width).zzj((long)zzu5.id).zzk(zzu5.zzaz).zzgd())).zzgd());
        zzef.zzo zzo2 = (zzef.zzo)((zzgx)zzef.zzo.zzdj().zzb(zzi2).zzgd());
        dynamiteClearcutLogger.zza(3, zzo2);
    }
}

