/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzbjr;
import com.google.android.gms.internal.zzbjt;
import com.google.android.gms.internal.zzbjv;
import com.google.android.gms.internal.zzbjw;
import com.google.android.gms.internal.zzbjx;
import com.google.android.gms.internal.zzbjz;
import com.google.android.gms.internal.zzbka;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import java.nio.ByteBuffer;

public class zzbjq
extends zzbjz<zzbjv> {
    private final zzbjt zzbPb;

    public zzbjq(Context context, zzbjt zzbjt2) {
        super(context, "FaceNativeHandle");
        this.zzbPb = zzbjt2;
        this.zzTR();
    }

    public Face[] zzb(ByteBuffer byteBuffer, zzbka zzbka2) {
        zzbjr[] zzbjrArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zzd.zzA((Object)byteBuffer);
            zzbjrArray = ((zzbjv)this.zzTR()).zzc((IObjectWrapper)faceArray, zzbka2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[zzbjrArray.length];
        for (int i = 0; i < zzbjrArray.length; ++i) {
            faceArray[i] = this.zza(zzbjrArray[i]);
        }
        return faceArray;
    }

    public boolean zzoh(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzbjv)this.zzTR()).zzoh(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected zzbjv zzc(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.zza {
        zzbjw zzbjw2 = zzbjw.zza.zzfq(dynamiteModule.zzdT("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        IObjectWrapper iObjectWrapper = zzd.zzA((Object)context);
        return zzbjw2.zza(iObjectWrapper, this.zzbPb);
    }

    @Override
    protected void zzTO() throws RemoteException {
        ((zzbjv)this.zzTR()).zzTP();
    }

    private Face zza(zzbjr zzbjr2) {
        return new Face(zzbjr2.id, new PointF(zzbjr2.centerX, zzbjr2.centerY), zzbjr2.width, zzbjr2.height, zzbjr2.zzbPc, zzbjr2.zzbPd, this.zzb(zzbjr2), zzbjr2.zzbPf, zzbjr2.zzbPg, zzbjr2.zzbPh);
    }

    private Landmark[] zzb(zzbjr zzbjr2) {
        Landmark[] landmarkArray;
        zzbjx[] zzbjxArray = zzbjr2.zzbPe;
        if (zzbjxArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[zzbjxArray.length];
            for (int i = 0; i < zzbjxArray.length; ++i) {
                landmarkArray[i] = this.zza(zzbjxArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(zzbjx zzbjx2) {
        return new Landmark(new PointF(zzbjx2.x, zzbjx2.y), zzbjx2.type);
    }

    @Override
    protected /* synthetic */ Object zzb(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.zza {
        return this.zzc(dynamiteModule, context);
    }
}

