/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context mContext;
    private final Object zzbNP = new Object();
    private Camera zzbNQ;
    private int zzbNR = 0;
    private int zzMA;
    private Size zzbNS;
    private float zzbNT = 30.0f;
    private int zzbNU = 1024;
    private int zzbNV = 768;
    private boolean zzbNW = false;
    private SurfaceTexture zzbNX;
    private boolean zzbNY;
    private Thread zzbNZ;
    private zzb zzbOa;
    private Map<byte[], ByteBuffer> zzbOb = new HashMap<byte[], ByteBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbNP;
        synchronized (object) {
            this.stop();
            this.zzbOa.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start() throws IOException {
        Object object = this.zzbNP;
        synchronized (object) {
            if (this.zzbNQ != null) {
                return this;
            }
            this.zzbNQ = this.zzTM();
            this.zzbNX = new SurfaceTexture(100);
            this.zzbNQ.setPreviewTexture(this.zzbNX);
            this.zzbNY = true;
            this.zzbNQ.startPreview();
            this.zzbNZ = new Thread(this.zzbOa);
            this.zzbOa.setActive(true);
            this.zzbNZ.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    public CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzbNP;
        synchronized (object) {
            if (this.zzbNQ != null) {
                return this;
            }
            this.zzbNQ = this.zzTM();
            this.zzbNQ.setPreviewDisplay(surfaceHolder);
            this.zzbNQ.startPreview();
            this.zzbNZ = new Thread(this.zzbOa);
            this.zzbOa.setActive(true);
            this.zzbNZ.start();
            this.zzbNY = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzbNP;
        synchronized (object) {
            this.zzbOa.setActive(false);
            if (this.zzbNZ != null) {
                try {
                    this.zzbNZ.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzbNZ = null;
            }
            if (this.zzbNQ != null) {
                this.zzbNQ.stopPreview();
                this.zzbNQ.setPreviewCallbackWithBuffer(null);
                try {
                    if (this.zzbNY) {
                        this.zzbNQ.setPreviewTexture(null);
                    } else {
                        this.zzbNQ.setPreviewDisplay(null);
                    }
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                this.zzbNQ.release();
                this.zzbNQ = null;
            }
            this.zzbOb.clear();
        }
    }

    public Size getPreviewSize() {
        return this.zzbNS;
    }

    public int getCameraFacing() {
        return this.zzbNR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(ShutterCallback shutterCallback, PictureCallback pictureCallback) {
        Object object = this.zzbNP;
        synchronized (object) {
            if (this.zzbNQ != null) {
                zzd zzd2 = new zzd(this);
                zzd2.zzbOj = shutterCallback;
                zzc zzc2 = new zzc();
                zzc2.zzbOi = pictureCallback;
                this.zzbNQ.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera zzTM() {
        int n = CameraSource.zznP(this.zzbNR);
        if (n == -1) {
            throw new RuntimeException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n);
        zze zze2 = CameraSource.zza(camera, this.zzbNU, this.zzbNV);
        if (zze2 == null) {
            throw new RuntimeException("Could not find suitable preview size.");
        }
        Size size = zze2.zzTO();
        this.zzbNS = zze2.zzTN();
        int[] nArray = CameraSource.zza(camera, this.zzbNT);
        if (nArray == null) {
            throw new RuntimeException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (size != null) {
            parameters.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters.setPreviewSize(this.zzbNS.getWidth(), this.zzbNS.getHeight());
        parameters.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters.setPreviewFormat(17);
        this.zza(camera, parameters, n);
        if (this.zzbNW) {
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zza());
        camera.addCallbackBuffer(this.zza(this.zzbNS));
        camera.addCallbackBuffer(this.zza(this.zzbNS));
        camera.addCallbackBuffer(this.zza(this.zzbNS));
        camera.addCallbackBuffer(this.zza(this.zzbNS));
        return camera;
    }

    private static int zznP(int n) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != n) continue;
            return i;
        }
        return -1;
    }

    static zze zza(Camera camera, int n, int n2) {
        List<zze> list = CameraSource.zza(camera);
        zze zze2 = null;
        int n3 = Integer.MAX_VALUE;
        for (zze zze3 : list) {
            Size size = zze3.zzTN();
            int n4 = Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2);
            if (n4 >= n3) continue;
            zze2 = zze3;
            n3 = n4;
        }
        return zze2;
    }

    static List<zze> zza(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block0: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        return arrayList;
    }

    @SuppressLint(value={"InlinedApi"})
    static int[] zza(Camera camera, float f) {
        int n = (int)(f * 1000.0f);
        int[] nArray = null;
        int n2 = Integer.MAX_VALUE;
        List list = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] nArray2 : list) {
            int n3 = n - nArray2[0];
            int n4 = n - nArray2[1];
            int n5 = Math.abs(n3) + Math.abs(n4);
            if (n5 >= n2) continue;
            nArray = nArray2;
            n2 = n5;
        }
        return nArray;
    }

    private void zza(Camera camera, Camera.Parameters parameters, int n) {
        int n2;
        int n3;
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n4 = 0;
        int n5 = windowManager.getDefaultDisplay().getRotation();
        switch (n5) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n5).toString());
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n3) % 360;
        } else {
            n2 = n3 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        this.zzMA = n3 / 90;
        camera.setDisplayOrientation(n2);
        parameters.setRotation(n3);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        long l = size.getHeight() * size.getWidth() * n;
        int n2 = (int)Math.ceil((double)l / 8.0) + 1;
        byte[] byArray = new byte[n2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzbOb.put(byArray, byteBuffer);
        return byArray;
    }

    private class zzb
    implements Runnable {
        private Detector<?> zzbOc;
        private long zzafe = SystemClock.elapsedRealtime();
        private final Object zzrJ = new Object();
        private boolean mActive = true;
        private long zzbOf;
        private int zzbOg = 0;
        private ByteBuffer zzbOh;

        zzb(Detector<?> detector) {
            this.zzbOc = detector;
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.zzbNZ.getState() == Thread.State.TERMINATED);
            this.zzbOc.release();
            this.zzbOc = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean bl) {
            Object object = this.zzrJ;
            synchronized (object) {
                this.mActive = bl;
                this.zzrJ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zza(byte[] byArray, Camera camera) {
            Object object = this.zzrJ;
            synchronized (object) {
                if (this.zzbOh != null) {
                    camera.addCallbackBuffer(this.zzbOh.array());
                    this.zzbOh = null;
                }
                if (!CameraSource.this.zzbOb.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zzbOf = SystemClock.elapsedRealtime() - this.zzafe;
                ++this.zzbOg;
                this.zzbOh = (ByteBuffer)CameraSource.this.zzbOb.get(byArray);
                this.zzrJ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzrJ;
                synchronized (object) {
                    while (this.mActive && this.zzbOh == null) {
                        try {
                            this.zzrJ.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.mActive) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData(this.zzbOh, CameraSource.this.zzbNS.getWidth(), CameraSource.this.zzbNS.getHeight(), 17).setId(this.zzbOg).setTimestampMillis(this.zzbOf).setRotation(CameraSource.this.zzMA).build();
                    byteBuffer = this.zzbOh;
                    this.zzbOh = null;
                }
                try {
                    this.zzbOc.receiveFrame(frame);
                    continue;
                }
                catch (Throwable throwable) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)throwable);
                    continue;
                }
                finally {
                    CameraSource.this.zzbNQ.addCallbackBuffer(byteBuffer.array());
                    continue;
                }
                break;
            }
        }
    }

    private class zza
    implements Camera.PreviewCallback {
        private zza() {
        }

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.zzbOa.zza(byArray, camera);
        }
    }

    static class zze {
        private Size zzbOk;
        private Size zzbOl;

        public zze(Camera.Size size, Camera.Size size2) {
            this.zzbOk = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzbOl = new Size(size2.width, size2.height);
            }
        }

        public Size zzTN() {
            return this.zzbOk;
        }

        public Size zzTO() {
            return this.zzbOl;
        }
    }

    private class zzc
    implements Camera.PictureCallback {
        private PictureCallback zzbOi;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zzbOi != null) {
                this.zzbOi.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.zzbNP;
            synchronized (object) {
                if (CameraSource.this.zzbNQ != null) {
                    CameraSource.this.zzbNQ.startPreview();
                }
            }
        }
    }

    private class zzd
    implements Camera.ShutterCallback {
        private ShutterCallback zzbOj;

        private zzd(CameraSource cameraSource) {
        }

        public void onShutter() {
            if (this.zzbOj != null) {
                this.zzbOj.onShutter();
            }
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zzbOc;
        private CameraSource zzbOd = new CameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zzbOc = detector;
            this.zzbOd.mContext = context;
        }

        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzbOd.zzbNT = f;
            return this;
        }

        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzbOd.zzbNU = n;
            this.zzbOd.zzbNV = n2;
            return this;
        }

        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzbOd.zzbNR = n;
            return this;
        }

        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzbOd.zzbNW = bl;
            return this;
        }

        public CameraSource build() {
            CameraSource cameraSource = this.zzbOd;
            cameraSource.getClass();
            this.zzbOd.zzbOa = cameraSource.new zzb(this.zzbOc);
            return this.zzbOd;
        }
    }
}

