/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdbw;
import com.google.android.gms.internal.zzdby;
import com.google.android.gms.internal.zzdce;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzdby zzkhy;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzdby zzdby2) {
        this.zzkhy = zzdby2;
    }

    public final void release() {
        super.release();
        this.zzkhy.zzbim();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdce zzdce2 = zzdce.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzkhy.zza(frame.getBitmap(), zzdce2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzkhy.zza(byteBuffer, zzdce2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzkhy.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzdby zzdby2, zzc zzc2) {
        this(zzdby2);
    }

    public static class Builder {
        private Context mContext;
        private zzdbw zzkhz;

        public Builder(Context context) {
            this.mContext = context;
            this.zzkhz = new zzdbw();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzkhz.zzkia = n;
            return this;
        }

        public BarcodeDetector build() {
            zzdby zzdby2 = new zzdby(this.mContext, this.zzkhz);
            return new BarcodeDetector(zzdby2, null);
        }
    }
}

