/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdcg;
import com.google.android.gms.internal.zzdcm;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdcm[] zzkji;
    private Point[] cornerPoints;
    private List<Line> zzkjj;
    private String zzkjk;
    private Rect zzkjl;

    TextBlock(SparseArray<zzdcm> sparseArray) {
        this.zzkji = new zzdcm[sparseArray.size()];
        for (int i = 0; i < this.zzkji.length; ++i) {
            this.zzkji[i] = (zzdcm)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzkjk != null) {
            return this.zzkjk;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdcm[] zzdcmArray = this.zzkji;
        int n = this.zzkji.length;
        for (int i = 0; i < n; ++i) {
            zzdcm zzdcm2 = zzdcmArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdcm2.zzkjk)) {
                n2 = (Integer)hashMap.get(zzdcm2.zzkjk);
            }
            hashMap.put(zzdcm2.zzkjk, n2 + 1);
        }
        this.zzkjk = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzkjk == null || this.zzkjk.isEmpty()) {
            this.zzkjk = "und";
        }
        return this.zzkjk;
    }

    @Override
    public String getValue() {
        if (this.zzkji.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzkji[0].zzkjt);
        for (int i = 1; i < this.zzkji.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzkji[i].zzkjt);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdcg zzdcg2) {
        int n5 = zzdcg2.left;
        int n6 = zzdcg2.top;
        double d = Math.sin(Math.toRadians(zzdcg2.zzkjo));
        double d2 = Math.cos(Math.toRadians(zzdcg2.zzkjo));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzkji.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzkji.length; ++i) {
                    zzdcg zzdcg2 = textBlock.zzkji[0].zzkjq;
                    zzdcg zzdcg3 = textBlock.zzkji[i].zzkjq;
                    int n5 = -zzdcg2.left;
                    int n6 = -zzdcg2.top;
                    double d = Math.sin(Math.toRadians(zzdcg2.zzkjo));
                    double d2 = Math.cos(Math.toRadians(zzdcg2.zzkjo));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdcg3.left, zzdcg3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdcg3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdcg3.width, n8 + zzdcg3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdcg3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzkji[0].zzkjq);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzkji.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzkjj == null) {
            textBlock.zzkjj = new ArrayList<Line>(textBlock.zzkji.length);
            zzdcm[] zzdcmArray = textBlock.zzkji;
            int n = textBlock.zzkji.length;
            for (int i = 0; i < n; ++i) {
                zzdcm zzdcm2 = zzdcmArray[i];
                textBlock.zzkjj.add(new Line(zzdcm2));
            }
        }
        return textBlock.zzkjj;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzkjl == null) {
            this.zzkjl = zzc.zza(this);
        }
        return this.zzkjl;
    }
}

