/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdcc;
import com.google.android.gms.internal.zzdce;
import com.google.android.gms.internal.zzdck;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzdce zzkij;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzdce zzdce2) {
        this.zzkij = zzdce2;
    }

    public final void release() {
        super.release();
        this.zzkij.zzbio();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzdck zzdck2 = zzdck.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzkij.zza(frame.getBitmap(), zzdck2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzkij.zza(byteBuffer, zzdck2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzkij.isOperational();
    }

    /* synthetic */ BarcodeDetector(zzdce zzdce2, zzc zzc2) {
        this(zzdce2);
    }

    public static class Builder {
        private Context mContext;
        private zzdcc zzkik;

        public Builder(Context context) {
            this.mContext = context;
            this.zzkik = new zzdcc();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzkik.zzkil = n;
            return this;
        }

        public BarcodeDetector build() {
            zzdce zzdce2 = new zzdce(this.mContext, this.zzkik);
            return new BarcodeDetector(zzdce2, null);
        }
    }
}

