/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzdiw;
import com.google.android.gms.internal.zzdjc;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private zzdjc[] zzkvn;
    private Point[] cornerPoints;
    private List<Line> zzkvo;
    private String zzkvp;
    private Rect zzkvq;

    TextBlock(SparseArray<zzdjc> sparseArray) {
        this.zzkvn = new zzdjc[sparseArray.size()];
        for (int i = 0; i < this.zzkvn.length; ++i) {
            this.zzkvn[i] = (zzdjc)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzkvp != null) {
            return this.zzkvp;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        zzdjc[] zzdjcArray = this.zzkvn;
        int n = this.zzkvn.length;
        for (int i = 0; i < n; ++i) {
            zzdjc zzdjc2 = zzdjcArray[i];
            int n2 = 0;
            if (hashMap.containsKey(zzdjc2.zzkvp)) {
                n2 = (Integer)hashMap.get(zzdjc2.zzkvp);
            }
            hashMap.put(zzdjc2.zzkvp, n2 + 1);
        }
        this.zzkvp = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzkvp == null || this.zzkvp.isEmpty()) {
            this.zzkvp = "und";
        }
        return this.zzkvp;
    }

    @Override
    public String getValue() {
        if (this.zzkvn.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzkvn[0].zzkvy);
        for (int i = 1; i < this.zzkvn.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzkvn[i].zzkvy);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzdiw zzdiw2) {
        int n5 = zzdiw2.left;
        int n6 = zzdiw2.top;
        double d = Math.sin(Math.toRadians(zzdiw2.zzkvt));
        double d2 = Math.cos(Math.toRadians(zzdiw2.zzkvt));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzkvn.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzkvn.length; ++i) {
                    zzdiw zzdiw2 = textBlock.zzkvn[0].zzkvv;
                    zzdiw zzdiw3 = textBlock.zzkvn[i].zzkvv;
                    int n5 = -zzdiw2.left;
                    int n6 = -zzdiw2.top;
                    double d = Math.sin(Math.toRadians(zzdiw2.zzkvt));
                    double d2 = Math.cos(Math.toRadians(zzdiw2.zzkvt));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(zzdiw3.left, zzdiw3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + zzdiw3.width, n8);
                    pointArray2[2] = new Point(n7 + zzdiw3.width, n8 + zzdiw3.height);
                    pointArray2[3] = new Point(n7, n8 + zzdiw3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzkvn[0].zzkvv);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzkvn.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzkvo == null) {
            textBlock.zzkvo = new ArrayList<Line>(textBlock.zzkvn.length);
            zzdjc[] zzdjcArray = textBlock.zzkvn;
            int n = textBlock.zzkvn.length;
            for (int i = 0; i < n; ++i) {
                zzdjc zzdjc2 = zzdjcArray[i];
                textBlock.zzkvo.add(new Line(zzdjc2));
            }
        }
        return textBlock.zzkvo;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzkvq == null) {
            this.zzkvq = zzc.zza(this);
        }
        return this.zzkvq;
    }
}

