/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face.internal.client;

import android.content.Context;
import android.graphics.PointF;
import android.media.Image;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.vision.zzs;
import com.google.android.gms.internal.vision.zzt;
import com.google.android.gms.internal.vision.zzu;
import com.google.android.gms.vision.face.Contour;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import com.google.android.gms.vision.face.internal.client.FaceParcel;
import com.google.android.gms.vision.face.internal.client.zzf;
import com.google.android.gms.vision.face.internal.client.zzh;
import com.google.android.gms.vision.face.internal.client.zzi;
import com.google.android.gms.vision.face.internal.client.zzl;
import java.nio.ByteBuffer;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;

public final class zzb
extends zzt<zzh> {
    private final zzf zza;

    public zzb(Context context, zzf zzf2) {
        super(context, "FaceNativeHandle", "face");
        this.zza = zzf2;
        this.zzd();
    }

    public final Face[] zza(ByteBuffer byteBuffer, zzs zzs2) {
        FaceParcel[] faceParcelArray;
        Face[] faceArray;
        if (!this.zzb()) {
            return new Face[0];
        }
        try {
            faceArray = ObjectWrapper.wrap((Object)byteBuffer);
            faceParcelArray = ((zzh)Preconditions.checkNotNull((Object)((zzh)this.zzd()))).zza((IObjectWrapper)faceArray, zzs2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = zzb.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    @RequiresApi(value=19)
    public final Face[] zza(Image.Plane[] planeArray, zzs zzs2) {
        FaceParcel[] faceParcelArray;
        if (!this.zzb()) {
            Log.e((String)"FaceNativeHandle", (String)"Native handle is not ready to be used.");
            return new Face[0];
        }
        if (planeArray != null && planeArray.length != 3) {
            throw new IllegalArgumentException("Only android.graphics.ImageFormat#YUV_420_888 is supported which should have 3 planes.");
        }
        try {
            faceParcelArray = ((zzh)Preconditions.checkNotNull((Object)((zzh)this.zzd()))).zza(ObjectWrapper.wrap((Object)planeArray[0].getBuffer()), ObjectWrapper.wrap((Object)planeArray[1].getBuffer()), ObjectWrapper.wrap((Object)planeArray[2].getBuffer()), planeArray[0].getPixelStride(), planeArray[1].getPixelStride(), planeArray[2].getPixelStride(), planeArray[0].getRowStride(), planeArray[1].getRowStride(), planeArray[2].getRowStride(), zzs2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        Face[] faceArray = new Face[faceParcelArray.length];
        for (int i = 0; i < faceParcelArray.length; ++i) {
            faceArray[i] = zzb.zza(faceParcelArray[i]);
        }
        return faceArray;
    }

    public final boolean zza(int n) {
        if (!this.zzb()) {
            return false;
        }
        try {
            return ((zzh)Preconditions.checkNotNull((Object)((zzh)this.zzd()))).zza(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected final void zza() throws RemoteException {
        ((zzh)Preconditions.checkNotNull((Object)((zzh)this.zzd()))).zza();
    }

    private static Face zza(FaceParcel faceParcel) {
        AbstractSafeParcelable abstractSafeParcelable;
        int n;
        Object[] objectArray;
        int n2 = faceParcel.zza;
        PointF pointF = new PointF(faceParcel.zzb, faceParcel.zzc);
        float f = faceParcel.zzd;
        float f2 = faceParcel.zze;
        float f3 = faceParcel.zzf;
        float f4 = faceParcel.zzg;
        float f5 = faceParcel.zzh;
        AbstractSafeParcelable[] abstractSafeParcelableArray = faceParcel.zzi;
        if (faceParcel.zzi == null) {
            objectArray = new Landmark[]{};
        } else {
            objectArray = new Landmark[abstractSafeParcelableArray.length];
            for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                abstractSafeParcelable = abstractSafeParcelableArray[n];
                objectArray[n] = new Landmark(new PointF(abstractSafeParcelable.zza, abstractSafeParcelable.zzb), abstractSafeParcelable.zzc);
            }
        }
        Landmark[] landmarkArray = objectArray;
        abstractSafeParcelableArray = faceParcel.zzm;
        if (faceParcel.zzm == null) {
            objectArray = new Contour[]{};
        } else {
            objectArray = new Contour[abstractSafeParcelableArray.length];
            for (n = 0; n < abstractSafeParcelableArray.length; ++n) {
                abstractSafeParcelable = abstractSafeParcelableArray[n];
                objectArray[n] = new Contour(abstractSafeParcelable.zza, abstractSafeParcelable.zzb);
            }
        }
        return new Face(n2, pointF, f, f2, f3, f4, f5, landmarkArray, (Contour[])objectArray, faceParcel.zzj, faceParcel.zzk, faceParcel.zzl, faceParcel.zzn);
    }

    @Nullable
    protected final /* synthetic */ Object zza(@UnknownInitialization zzb this, DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.LoadingException {
        Context context2 = context;
        DynamiteModule dynamiteModule2 = dynamiteModule;
        zzb zzb2 = this;
        zzi zzi2 = zzu.zza((Context)context2, (String)"com.google.android.gms.vision.dynamite.face") ? zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.NativeFaceDetectorV2Creator")) : zzl.asInterface(dynamiteModule2.instantiate("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        if (zzi2 == null) {
            return null;
        }
        IObjectWrapper iObjectWrapper = ObjectWrapper.wrap((Object)context2);
        return zzi2.newFaceDetector(iObjectWrapper, (zzf)((Object)Preconditions.checkNotNull((Object)((Object)zzb2.zza))));
    }
}

