/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbhS = new Object();
    private Processor<T> zzbhT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbhS;
        synchronized (object) {
            if (this.zzbhT != null) {
                this.zzbhT.release();
                this.zzbhT = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int id) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbhS;
        synchronized (object) {
            if (this.zzbhT == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzGk();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbhT.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbhT = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbhU;
        private Frame.Metadata zzbhV;
        private boolean zzbhW;

        public Detections(SparseArray<T> detectedItems, Frame.Metadata frameMetadata, boolean isOperational) {
            this.zzbhU = detectedItems;
            this.zzbhV = frameMetadata;
            this.zzbhW = isOperational;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbhU;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbhV;
        }

        public boolean detectorIsOperational() {
            return this.zzbhW;
        }
    }
}

