/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzbic = new Metadata();
    private ByteBuffer zzbid = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzbic;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzGj();
        }
        return this.zzbid;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzGj() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        return ByteBuffer.wrap(byArray);
    }

    public static class Metadata {
        private int zzov;
        private int zzow;
        private int mId;
        private long zzaGy;
        private int zzCE;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zzov = metadata.getWidth();
            this.zzow = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzaGy = metadata.getTimestampMillis();
            this.zzCE = metadata.getRotation();
        }

        public int getWidth() {
            return this.zzov;
        }

        public int getHeight() {
            return this.zzow;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzaGy;
        }

        public int getRotation() {
            return this.zzCE;
        }

        public void zzGk() {
            if (this.zzCE % 2 != 0) {
                int n = this.zzov;
                this.zzov = this.zzow;
                this.zzow = n;
            }
            this.zzCE = 0;
        }
    }

    public static class Builder {
        private Frame zzbie = new Frame();

        public Builder setBitmap(Bitmap image) {
            int n = image.getWidth();
            int n2 = image.getHeight();
            this.zzbie.mBitmap = image;
            Metadata metadata = this.zzbie.getMetadata();
            metadata.zzov = n;
            metadata.zzow = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer data, int width, int height, int format) {
            if (data == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (data.capacity() < width * height) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (format) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image format: " + format);
                }
            }
            this.zzbie.zzbid = data;
            Metadata metadata = this.zzbie.getMetadata();
            metadata.zzov = width;
            metadata.zzow = height;
            return this;
        }

        public Builder setId(int id) {
            this.zzbie.getMetadata().mId = id;
            return this;
        }

        public Builder setTimestampMillis(long timestampMillis) {
            this.zzbie.getMetadata().zzaGy = timestampMillis;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.zzbie.getMetadata().zzCE = rotation;
            return this;
        }

        public Frame build() {
            if (this.zzbie.zzbid == null && this.zzbie.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzbie;
        }
    }
}

