/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzbik;
    private SparseArray<zza> zzbil = new SparseArray();
    private int zzbhY = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzbil.size(); ++i) {
            Tracker tracker = ((zza)this.zzbil.valueAt(i)).zzbhX;
            tracker.onDone();
        }
        this.zzbil.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzbil.get(n) != null) continue;
            zza zza2 = new zza();
            zza2.zzbhX = this.zzbik.create(object);
            zza2.zzbhX.onNewItem(n, object);
            this.zzbil.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzbil.size(); ++i) {
            int n = this.zzbil.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzbil.valueAt(i);
            zza2.zzbib++;
            if (zza2.zzbib >= this.zzbhY) {
                zza2.zzbhX.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.zzbhX.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.zzbil.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.zzbil.get(n);
            zza2.zzbib = 0;
            zza2.zzbhX.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> zzbhX;
        private int zzbib = 0;

        private zza() {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzbim = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzbim).zzbik = factory;
        }

        public Builder<T> setMaxGapFrames(int maxGapFrames) {
            if (maxGapFrames < 0) {
                throw new IllegalArgumentException("Invalid max gap: " + maxGapFrames);
            }
            ((MultiProcessor)this.zzbim).zzbhY = maxGapFrames;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzbim;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

