/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF zzbit;
    private float zzaQo;
    private float zzaQp;
    private float zzbiu;
    private float zzbiv;
    private List<Landmark> zzbiw;
    private float zzbix;
    private float zzbiy;
    private float zzbiz;

    public PointF getPosition() {
        return new PointF(this.zzbit.x - this.zzaQo / 2.0f, this.zzbit.y - this.zzaQp / 2.0f);
    }

    public float getWidth() {
        return this.zzaQo;
    }

    public float getHeight() {
        return this.zzaQp;
    }

    public float getEulerY() {
        return this.zzbiu;
    }

    public float getEulerZ() {
        return this.zzbiv;
    }

    public List<Landmark> getLandmarks() {
        return this.zzbiw;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.zzbix;
    }

    public float getIsRightEyeOpenProbability() {
        return this.zzbiy;
    }

    public float getIsSmilingProbability() {
        return this.zzbiz;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int id, PointF position, float width, float height, float yawDegrees, float rollDegrees, Landmark[] landmarks, float isLeftEyeOpenScore, float isRightEyeOpenScore, float isSmilingScore) {
        this.mId = id;
        this.zzbit = position;
        this.zzaQo = width;
        this.zzaQp = height;
        this.zzbiu = yawDegrees;
        this.zzbiv = rollDegrees;
        this.zzbiw = Arrays.asList(landmarks);
        this.zzbix = isLeftEyeOpenScore >= 0.0f && isLeftEyeOpenScore <= 1.0f ? isLeftEyeOpenScore : -1.0f;
        this.zzbiy = isRightEyeOpenScore >= 0.0f && isRightEyeOpenScore <= 1.0f ? isRightEyeOpenScore : -1.0f;
        this.zzbiz = this.zzbiz >= 0.0f && this.zzbiz <= 1.0f ? isSmilingScore : -1.0f;
    }
}

