/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.util.ArrayList;
import java.util.List;

public class MultiDetector
extends Detector<Object> {
    private List<Detector<? extends Object>> zzbno = new ArrayList<Detector<? extends Object>>();

    @Override
    public void release() {
        for (Detector<? extends Object> detector : this.zzbno) {
            detector.release();
        }
        this.zzbno.clear();
    }

    @Override
    public SparseArray<Object> detect(Frame frame) {
        SparseArray sparseArray = new SparseArray();
        for (Detector<? extends Object> detector : this.zzbno) {
            SparseArray<? extends Object> sparseArray2 = detector.detect(frame);
            for (int i = 0; i < sparseArray2.size(); ++i) {
                int n = sparseArray2.keyAt(i);
                if (sparseArray.get(n) != null) {
                    throw new IllegalStateException("Detection ID overlap for id = " + n + ".  " + "This means that one of the detectors is not using global IDs.");
                }
                Object object = sparseArray2.valueAt(i);
                sparseArray.append(n, object);
            }
        }
        return sparseArray;
    }

    @Override
    public void receiveFrame(Frame frame) {
        for (Detector<? extends Object> detector : this.zzbno) {
            detector.receiveFrame(frame);
        }
    }

    @Override
    public void setProcessor(Detector.Processor<Object> processor) {
        throw new UnsupportedOperationException("MultiDetector.setProcessor is not supported.  You should set a processor instance on each underlying detector instead.");
    }

    @Override
    public boolean isOperational() {
        for (Detector<? extends Object> detector : this.zzbno) {
            if (detector.isOperational()) continue;
            return false;
        }
        return true;
    }

    private MultiDetector() {
    }

    public static class Builder {
        private MultiDetector zzbnp = new MultiDetector();

        public Builder add(Detector<? extends Object> detector) {
            this.zzbnp.zzbno.add(detector);
            return this;
        }

        public MultiDetector build() {
            if (this.zzbnp.zzbno.size() == 0) {
                throw new RuntimeException("No underlying detectors added to MultiDetector.");
            }
            return this.zzbnp;
        }
    }
}

