/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.graphics.PointF;
import com.google.android.gms.vision.face.Landmark;
import java.util.Arrays;
import java.util.List;

public class Face {
    public static final float UNCOMPUTED_PROBABILITY = -1.0f;
    private int mId;
    private PointF aED;
    private float agV;
    private float agW;
    private float aEE;
    private float aEF;
    private List<Landmark> aEG;
    private float aEH;
    private float aEI;
    private float aEJ;

    public PointF getPosition() {
        return new PointF(this.aED.x - this.agV / 2.0f, this.aED.y - this.agW / 2.0f);
    }

    public float getWidth() {
        return this.agV;
    }

    public float getHeight() {
        return this.agW;
    }

    public float getEulerY() {
        return this.aEE;
    }

    public float getEulerZ() {
        return this.aEF;
    }

    public List<Landmark> getLandmarks() {
        return this.aEG;
    }

    public float getIsLeftEyeOpenProbability() {
        return this.aEH;
    }

    public float getIsRightEyeOpenProbability() {
        return this.aEI;
    }

    public float getIsSmilingProbability() {
        return this.aEJ;
    }

    public int getId() {
        return this.mId;
    }

    public Face(int n, PointF pointF, float f, float f2, float f3, float f4, Landmark[] landmarkArray, float f5, float f6, float f7) {
        this.mId = n;
        this.aED = pointF;
        this.agV = f;
        this.agW = f2;
        this.aEE = f3;
        this.aEF = f4;
        this.aEG = Arrays.asList(landmarkArray);
        this.aEH = f5 >= 0.0f && f5 <= 1.0f ? f5 : -1.0f;
        this.aEI = f6 >= 0.0f && f6 <= 1.0f ? f6 : -1.0f;
        this.aEJ = this.aEJ >= 0.0f && this.aEJ <= 1.0f ? f7 : -1.0f;
    }
}

