/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object aKq = new Object();
    private Processor<T> aKr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.aKq;
        synchronized (object) {
            if (this.aKr != null) {
                this.aKr.release();
                this.aKr = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.aKq;
        synchronized (object) {
            if (this.aKr == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzclp();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.aKr.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.aKr = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> aKs;
        private Frame.Metadata aKt;
        private boolean aKu;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.aKs = sparseArray;
            this.aKt = metadata;
            this.aKu = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.aKs;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.aKt;
        }

        public boolean detectorIsOperational() {
            return this.aKu;
        }
    }
}

