/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzg;
import com.google.android.gms.internal.zzbks;
import com.google.android.gms.internal.zzbkt;
import com.google.android.gms.internal.zzbkz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbRQ;
    private boolean mCreated = false;
    private final zzg zzbRR = zzg.zza((Fragment)this);
    private final zzc zzbRS = new zzc();
    private zza zzbRT = new zza(this);
    private final Fragment zzaRN = this;
    private WalletFragmentOptions zzbRU;
    private WalletFragmentInitParams zzbRV;
    private MaskedWalletRequest zzbRW;
    private MaskedWallet zzbRX;
    private Boolean zzbRY;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaRN.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbRQ != null) {
            this.zzbRQ.initialize(walletFragmentInitParams);
            this.zzbRV = null;
        } else if (this.zzbRV == null) {
            this.zzbRV = walletFragmentInitParams;
            if (this.zzbRW != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbRX != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbRQ != null) {
            this.zzbRQ.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbRW = null;
        } else {
            this.zzbRW = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbRQ != null) {
            this.zzbRQ.updateMaskedWallet(maskedWallet);
            this.zzbRX = null;
        } else {
            this.zzbRX = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.zzbRQ != null) {
            this.zzbRQ.setEnabled(bl);
            this.zzbRY = null;
        } else {
            this.zzbRY = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbRT.zza(onStateChangedListener);
    }

    public int getState() {
        return this.zzbRQ != null ? this.zzbRQ.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbRU == null) {
            this.zzbRU = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbRU);
        this.zzbRS.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbRV != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbRV = walletFragmentInitParams;
            }
            if (this.zzbRW == null) {
                this.zzbRW = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbRX == null) {
                this.zzbRX = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbRU = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbRY = bundle.getBoolean("enabled");
            }
        } else if (this.zzaRN.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaRN.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzci((Context)this.zzaRN.getActivity());
            this.zzbRU = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbRS.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbRS.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.zzbRS.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzbRS.onResume();
        FragmentManager fragmentManager = this.zzaRN.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaRN.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzaRN.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzbRS.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzbRS.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbRS.onSaveInstanceState(bundle);
        if (this.zzbRV != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbRV);
            this.zzbRV = null;
        }
        if (this.zzbRW != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbRW);
            this.zzbRW = null;
        }
        if (this.zzbRX != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbRX);
            this.zzbRX = null;
        }
        if (this.zzbRU != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbRU);
            this.zzbRU = null;
        }
        if (this.zzbRY != null) {
            bundle.putBoolean("enabled", this.zzbRY.booleanValue());
            this.zzbRY = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbRQ != null) {
            this.zzbRQ.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzbkt.zza {
        private OnStateChangedListener zzbRZ;
        private final SupportWalletFragment zzbSa;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbSa = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzbRZ != null) {
                this.zzbRZ.onStateChanged(this.zzbSa, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbRZ = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzbks zzbSb;

        private zzb(zzbks zzbks2) {
            this.zzbSb = zzbks2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbSb.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.zzbSb.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbSb.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbSb.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbSb.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbSb.zza(zzd.zzA((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbSb.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                IObjectWrapper iObjectWrapper = this.zzbSb.onCreateView(zzd.zzA((Object)layoutInflater), zzd.zzA((Object)viewGroup), bundle);
                return (View)zzd.zzF((IObjectWrapper)iObjectWrapper);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbSb.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbSb.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbSb.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbSb.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbSb.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbSb.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zze<zzb> zze2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaRN.getActivity();
            if (SupportWalletFragment.this.zzbRQ == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzbks zzbks2 = zzbkz.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzbRR, SupportWalletFragment.this.zzbRU, SupportWalletFragment.this.zzbRT);
                    SupportWalletFragment.this.zzbRQ = new zzb(zzbks2);
                    SupportWalletFragment.this.zzbRU = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zze2.zza((LifecycleDelegate)SupportWalletFragment.this.zzbRQ);
                if (SupportWalletFragment.this.zzbRV != null) {
                    SupportWalletFragment.this.zzbRQ.initialize(SupportWalletFragment.this.zzbRV);
                    SupportWalletFragment.this.zzbRV = null;
                }
                if (SupportWalletFragment.this.zzbRW != null) {
                    SupportWalletFragment.this.zzbRQ.updateMaskedWalletRequest(SupportWalletFragment.this.zzbRW);
                    SupportWalletFragment.this.zzbRW = null;
                }
                if (SupportWalletFragment.this.zzbRX != null) {
                    SupportWalletFragment.this.zzbRQ.updateMaskedWallet(SupportWalletFragment.this.zzbRX);
                    SupportWalletFragment.this.zzbRX = null;
                }
                if (SupportWalletFragment.this.zzbRY != null) {
                    SupportWalletFragment.this.zzbRQ.setEnabled(SupportWalletFragment.this.zzbRY);
                    SupportWalletFragment.this.zzbRY = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzaRN.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzbRU != null && (walletFragmentStyle = SupportWalletFragment.this.zzbRU.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzaRN.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzaRN.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

