/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;
import com.google.android.gms.wallet.fragment.zzb;

public final class WalletFragmentOptions
extends zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<WalletFragmentOptions> CREATOR = new zzb();
    private int zzbRw;
    private int mTheme;
    private WalletFragmentStyle zzbSm;
    private int zzaKF;

    public static Builder newBuilder() {
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        ((Object)((Object)walletFragmentOptions)).getClass();
        return walletFragmentOptions.new Builder();
    }

    private WalletFragmentOptions() {
        this.zzbRw = 3;
        this.zzbSm = new WalletFragmentStyle();
    }

    WalletFragmentOptions(int n, int n2, WalletFragmentStyle walletFragmentStyle, int n3) {
        this.zzbRw = n;
        this.mTheme = n2;
        this.zzbSm = walletFragmentStyle;
        this.zzaKF = n3;
    }

    public int getEnvironment() {
        return this.zzbRw;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public WalletFragmentStyle getFragmentStyle() {
        return this.zzbSm;
    }

    public int getMode() {
        return this.zzaKF;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public void zzci(Context context) {
        if (this.zzbSm != null) {
            this.zzbSm.zzci(context);
        }
    }

    public static WalletFragmentOptions zzc(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WalletFragmentOptions);
        int n = typedArray.getInt(R.styleable.WalletFragmentOptions_appTheme, 0);
        int n2 = typedArray.getInt(R.styleable.WalletFragmentOptions_environment, 1);
        int n3 = typedArray.getResourceId(R.styleable.WalletFragmentOptions_fragmentStyle, 0);
        int n4 = typedArray.getInt(R.styleable.WalletFragmentOptions_fragmentMode, 1);
        typedArray.recycle();
        WalletFragmentOptions walletFragmentOptions = new WalletFragmentOptions();
        walletFragmentOptions.mTheme = n;
        walletFragmentOptions.zzbRw = n2;
        walletFragmentOptions.zzbSm = new WalletFragmentStyle().setStyleResourceId(n3);
        walletFragmentOptions.zzbSm.zzci(context);
        walletFragmentOptions.zzaKF = n4;
        return walletFragmentOptions;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setEnvironment(int n) {
            WalletFragmentOptions.this.zzbRw = n;
            return this;
        }

        public Builder setTheme(int n) {
            WalletFragmentOptions.this.mTheme = n;
            return this;
        }

        public Builder setFragmentStyle(int n) {
            WalletFragmentOptions.this.zzbSm = new WalletFragmentStyle().setStyleResourceId(n);
            return this;
        }

        public Builder setFragmentStyle(WalletFragmentStyle walletFragmentStyle) {
            WalletFragmentOptions.this.zzbSm = walletFragmentStyle;
            return this;
        }

        public Builder setMode(int n) {
            WalletFragmentOptions.this.zzaKF = n;
            return this;
        }

        public WalletFragmentOptions build() {
            return WalletFragmentOptions.this;
        }
    }
}

