/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.ga;
import com.google.android.gms.internal.ge;
import com.google.android.gms.internal.gz;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzbPZ;
    private boolean mCreated = false;
    private final zzr zzbQa = zzr.zza((Fragment)this);
    private final zzc zzbQb = new zzc(this, null);
    private zza zzbQc = new zza(this);
    private final Fragment zzaSE = this;
    private WalletFragmentOptions zzbQd;
    private WalletFragmentInitParams zzbQe;
    private MaskedWalletRequest zzbQf;
    private MaskedWallet zzbQg;
    private Boolean zzbQh;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzaSE.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzbPZ != null) {
            this.zzbPZ.initialize(walletFragmentInitParams);
            this.zzbQe = null;
            return;
        }
        if (this.zzbQe == null) {
            this.zzbQe = walletFragmentInitParams;
            if (this.zzbQf != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbQg != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzbPZ != null) {
            this.zzbPZ.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzbQf = null;
            return;
        }
        this.zzbQf = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbPZ != null) {
            this.zzbPZ.updateMaskedWallet(maskedWallet);
            this.zzbQg = null;
            return;
        }
        this.zzbQg = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzbPZ != null) {
            this.zzbPZ.setEnabled(bl);
            this.zzbQh = null;
            return;
        }
        this.zzbQh = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzbQc.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzbPZ != null) {
            return this.zzbPZ.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzbQd == null) {
            this.zzbQd = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbQd);
        this.zzbQb.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbQe != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbQe = walletFragmentInitParams;
            }
            if (this.zzbQf == null) {
                this.zzbQf = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzbQg == null) {
                this.zzbQg = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzbQd = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzbQh = bundle.getBoolean("enabled");
            }
        } else if (this.zzaSE.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzaSE.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzby((Context)this.zzaSE.getActivity());
            this.zzbQd = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzbQb.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzbQb.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzbQb.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzbQb.onResume();
        FragmentManager fragmentManager = this.zzaSE.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzaSE.getActivity()), (Activity)this.zzaSE.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzbQb.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzbQb.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzbQb.onSaveInstanceState(bundle);
        if (this.zzbQe != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbQe);
            this.zzbQe = null;
        }
        if (this.zzbQf != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzbQf);
            this.zzbQf = null;
        }
        if (this.zzbQg != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzbQg);
            this.zzbQg = null;
        }
        if (this.zzbQd != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzbQd);
            this.zzbQd = null;
        }
        if (this.zzbQh != null) {
            bundle.putBoolean("enabled", this.zzbQh.booleanValue());
            this.zzbQh = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzbPZ != null) {
            this.zzbPZ.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzbQd = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzbQe = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzbQf = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzbQg = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzbQh = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends ge {
        private OnStateChangedListener zzbQi;
        private final SupportWalletFragment zzbQj;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzbQj = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzbQi != null) {
                this.zzbQi.onStateChanged(this.zzbQj, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzbQi = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final ga zzbQk;

        private zzb(ga ga2) {
            this.zzbQk = ga2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzbQk.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzbQk.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzbQk.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbQk.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzbQk.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbQk.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzbQk.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzE((IObjectWrapper)this.zzbQk.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzbQk.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzbQk.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzbQk.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzbQk.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbQk.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzbQk.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(ga ga2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(ga2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzbQl;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzbQl = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzbQl.zzaSE.getActivity();
            if (this.zzbQl.zzbPZ == null && this.zzbQl.mCreated && fragmentActivity != null) {
                try {
                    ga ga2 = gz.zza((Activity)fragmentActivity, (zzk)this.zzbQl.zzbQa, this.zzbQl.zzbQd, this.zzbQl.zzbQc);
                    this.zzbQl.zzbPZ = new zzb(ga2, null);
                    SupportWalletFragment.zza(this.zzbQl, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzbQl.zzbPZ);
                if (this.zzbQl.zzbQe != null) {
                    this.zzbQl.zzbPZ.initialize(this.zzbQl.zzbQe);
                    SupportWalletFragment.zza(this.zzbQl, null);
                }
                if (this.zzbQl.zzbQf != null) {
                    this.zzbQl.zzbPZ.updateMaskedWalletRequest(this.zzbQl.zzbQf);
                    SupportWalletFragment.zza(this.zzbQl, null);
                }
                if (this.zzbQl.zzbQg != null) {
                    this.zzbQl.zzbPZ.updateMaskedWallet(this.zzbQl.zzbQg);
                    SupportWalletFragment.zza(this.zzbQl, null);
                }
                if (this.zzbQl.zzbQh != null) {
                    this.zzbQl.zzbPZ.setEnabled(this.zzbQl.zzbQh);
                    SupportWalletFragment.zza(this.zzbQl, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzbQl.zzaSE.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzbQl.zzbQd != null && (walletFragmentStyle = this.zzbQl.zzbQd.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzbQl.zzaSE.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzbQl.zzaSE.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

