/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.dynamic.zzr;
import com.google.android.gms.internal.zzddi;
import com.google.android.gms.internal.zzddm;
import com.google.android.gms.internal.zzdee;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzknp;
    private boolean mCreated = false;
    private final zzr zzknq = zzr.zza((Fragment)this);
    private final zzc zzknr = new zzc(this, null);
    private zza zzkns = new zza(this);
    private final Fragment zzgoy = this;
    private WalletFragmentOptions zzknt;
    private WalletFragmentInitParams zzknu;
    private MaskedWalletRequest zzknv;
    private MaskedWallet zzknw;
    private Boolean zzknx;

    public SupportWalletFragment() {
    }

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.zzgoy.setArguments(bundle);
        return supportWalletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzknp != null) {
            this.zzknp.initialize(walletFragmentInitParams);
            this.zzknu = null;
            return;
        }
        if (this.zzknu == null) {
            this.zzknu = walletFragmentInitParams;
            if (this.zzknv != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzknw != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzknp != null) {
            this.zzknp.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzknv = null;
            return;
        }
        this.zzknv = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzknp != null) {
            this.zzknp.updateMaskedWallet(maskedWallet);
            this.zzknw = null;
            return;
        }
        this.zzknw = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzknp != null) {
            this.zzknp.setEnabled(bl);
            this.zzknx = null;
            return;
        }
        this.zzknx = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzkns.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzknp != null) {
            return this.zzknp.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzknt == null) {
            this.zzknt = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzknt);
        this.zzknr.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzknu != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzknu = walletFragmentInitParams;
            }
            if (this.zzknv == null) {
                this.zzknv = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzknw == null) {
                this.zzknw = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzknt = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzknx = bundle.getBoolean("enabled");
            }
        } else if (this.zzgoy.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgoy.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzeb((Context)this.zzgoy.getActivity());
            this.zzknt = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzknr.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzknr.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzknr.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzknr.onResume();
        FragmentManager fragmentManager = this.zzgoy.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgoy.getActivity()), (Activity)this.zzgoy.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzknr.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzknr.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzknr.onSaveInstanceState(bundle);
        if (this.zzknu != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzknu);
            this.zzknu = null;
        }
        if (this.zzknv != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzknv);
            this.zzknv = null;
        }
        if (this.zzknw != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzknw);
            this.zzknw = null;
        }
        if (this.zzknt != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzknt);
            this.zzknt = null;
        }
        if (this.zzknx != null) {
            bundle.putBoolean("enabled", this.zzknx.booleanValue());
            this.zzknx = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzknp != null) {
            this.zzknp.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(SupportWalletFragment supportWalletFragment, WalletFragmentOptions walletFragmentOptions) {
        supportWalletFragment.zzknt = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(SupportWalletFragment supportWalletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        supportWalletFragment.zzknu = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(SupportWalletFragment supportWalletFragment, MaskedWalletRequest maskedWalletRequest) {
        supportWalletFragment.zzknv = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(SupportWalletFragment supportWalletFragment, MaskedWallet maskedWallet) {
        supportWalletFragment.zzknw = null;
        return null;
    }

    static /* synthetic */ Boolean zza(SupportWalletFragment supportWalletFragment, Boolean bl) {
        supportWalletFragment.zzknx = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzddm {
        private OnStateChangedListener zzkny;
        private final SupportWalletFragment zzknz;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzknz = supportWalletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzkny != null) {
                this.zzkny.onStateChanged(this.zzknz, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzkny = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzddi zzkoa;

        private zzb(zzddi zzddi2) {
            this.zzkoa = zzddi2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzkoa.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzkoa.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzkoa.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzkoa.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzkoa.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzkoa.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzkoa.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzab((IObjectWrapper)this.zzkoa.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzkoa.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzkoa.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzkoa.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzkoa.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzkoa.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzkoa.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzddi zzddi2, com.google.android.gms.wallet.fragment.zza zza2) {
            this(zzddi2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ SupportWalletFragment zzkob;

        private zzc(SupportWalletFragment supportWalletFragment) {
            this.zzkob = supportWalletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            FragmentActivity fragmentActivity = this.zzkob.zzgoy.getActivity();
            if (this.zzkob.zzknp == null && this.zzkob.mCreated && fragmentActivity != null) {
                try {
                    zzddi zzddi2 = zzdee.zza((Activity)fragmentActivity, (zzk)this.zzkob.zzknq, this.zzkob.zzknt, this.zzkob.zzkns);
                    this.zzkob.zzknp = new zzb(zzddi2, null);
                    SupportWalletFragment.zza(this.zzkob, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzkob.zzknp);
                if (this.zzkob.zzknu != null) {
                    this.zzkob.zzknp.initialize(this.zzkob.zzknu);
                    SupportWalletFragment.zza(this.zzkob, null);
                }
                if (this.zzkob.zzknv != null) {
                    this.zzkob.zzknp.updateMaskedWalletRequest(this.zzkob.zzknv);
                    SupportWalletFragment.zza(this.zzkob, null);
                }
                if (this.zzkob.zzknw != null) {
                    this.zzkob.zzknp.updateMaskedWallet(this.zzkob.zzknw);
                    SupportWalletFragment.zza(this.zzkob, null);
                }
                if (this.zzkob.zzknx != null) {
                    this.zzkob.zzknp.setEnabled(this.zzkob.zzknx);
                    SupportWalletFragment.zza(this.zzkob, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzkob.zzgoy.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzkob.zzknt != null && (walletFragmentStyle = this.zzkob.zzknt.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzkob.zzgoy.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            FragmentActivity fragmentActivity = this.zzkob.zzgoy.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity), (Activity)fragmentActivity, (int)-1);
        }

        /* synthetic */ zzc(SupportWalletFragment supportWalletFragment, com.google.android.gms.wallet.fragment.zza zza2) {
            this(supportWalletFragment);
        }
    }
}

