/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzj;
import com.google.android.gms.dynamic.zzk;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.internal.zzddk;
import com.google.android.gms.internal.zzddo;
import com.google.android.gms.internal.zzdej;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

@TargetApi(value=12)
public final class WalletFragment
extends Fragment {
    private zzb zzkqe;
    private boolean mCreated = false;
    private final zzj zzkqf = zzj.zza((Fragment)this);
    private final zzc zzkqg = new zzc(this, null);
    private zza zzkqh = new zza(this);
    private final Fragment zzgpe = this;
    private WalletFragmentOptions zzkpv;
    private WalletFragmentInitParams zzkpw;
    private MaskedWalletRequest zzkpx;
    private MaskedWallet zzkpy;
    private Boolean zzkpz;

    public WalletFragment() {
    }

    public static WalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        walletFragment.zzgpe.setArguments(bundle);
        return walletFragment;
    }

    public final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.zzkqe != null) {
            this.zzkqe.initialize(walletFragmentInitParams);
            this.zzkpw = null;
            return;
        }
        if (this.zzkpw == null) {
            this.zzkpw = walletFragmentInitParams;
            if (this.zzkpx != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzkpy != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
                return;
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.zzkqe != null) {
            this.zzkqe.updateMaskedWalletRequest(maskedWalletRequest);
            this.zzkpx = null;
            return;
        }
        this.zzkpx = maskedWalletRequest;
    }

    public final void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzkqe != null) {
            this.zzkqe.updateMaskedWallet(maskedWallet);
            this.zzkpy = null;
            return;
        }
        this.zzkpy = maskedWallet;
    }

    public final void setEnabled(boolean bl) {
        if (this.zzkqe != null) {
            this.zzkqe.setEnabled(bl);
            this.zzkpz = null;
            return;
        }
        this.zzkpz = bl;
    }

    public final void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.zzkqh.zza(onStateChangedListener);
    }

    public final int getState() {
        if (this.zzkqe != null) {
            return this.zzkqe.getState();
        }
        return 0;
    }

    public final void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.zzkpv == null) {
            this.zzkpv = WalletFragmentOptions.zza((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzkpv);
        this.zzkqg.onInflate(activity, bundle2, bundle);
    }

    public final void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzkpw != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzkpw = walletFragmentInitParams;
            }
            if (this.zzkpx == null) {
                this.zzkpx = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.zzkpy == null) {
                this.zzkpy = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.zzkpv = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.zzkpz = bundle.getBoolean("enabled");
            }
        } else if (this.zzgpe.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzgpe.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzec((Context)this.zzgpe.getActivity());
            this.zzkpv = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzkqg.onCreate(bundle);
    }

    public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.zzkqg.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public final void onStart() {
        super.onStart();
        this.zzkqg.onStart();
    }

    public final void onResume() {
        super.onResume();
        this.zzkqg.onResume();
        FragmentManager fragmentManager = this.zzgpe.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzgpe.getActivity()), (Activity)this.zzgpe.getActivity(), (int)-1);
        }
    }

    public final void onPause() {
        super.onPause();
        this.zzkqg.onPause();
    }

    public final void onStop() {
        super.onStop();
        this.zzkqg.onStop();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzkqg.onSaveInstanceState(bundle);
        if (this.zzkpw != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.zzkpw);
            this.zzkpw = null;
        }
        if (this.zzkpx != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.zzkpx);
            this.zzkpx = null;
        }
        if (this.zzkpy != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.zzkpy);
            this.zzkpy = null;
        }
        if (this.zzkpv != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.zzkpv);
            this.zzkpv = null;
        }
        if (this.zzkpz != null) {
            bundle.putBoolean("enabled", this.zzkpz.booleanValue());
            this.zzkpz = null;
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.zzkqe != null) {
            this.zzkqe.onActivityResult(n, n2, intent);
        }
    }

    static /* synthetic */ WalletFragmentOptions zza(WalletFragment walletFragment, WalletFragmentOptions walletFragmentOptions) {
        walletFragment.zzkpv = null;
        return null;
    }

    static /* synthetic */ WalletFragmentInitParams zza(WalletFragment walletFragment, WalletFragmentInitParams walletFragmentInitParams) {
        walletFragment.zzkpw = null;
        return null;
    }

    static /* synthetic */ MaskedWalletRequest zza(WalletFragment walletFragment, MaskedWalletRequest maskedWalletRequest) {
        walletFragment.zzkpx = null;
        return null;
    }

    static /* synthetic */ MaskedWallet zza(WalletFragment walletFragment, MaskedWallet maskedWallet) {
        walletFragment.zzkpy = null;
        return null;
    }

    static /* synthetic */ Boolean zza(WalletFragment walletFragment, Boolean bl) {
        walletFragment.zzkpz = null;
        return null;
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static final class zza
    extends zzddo {
        private OnStateChangedListener zzkqi;
        private final WalletFragment zzkqj;

        zza(WalletFragment walletFragment) {
            this.zzkqj = walletFragment;
        }

        @Override
        public final void zza(int n, int n2, Bundle bundle) {
            if (this.zzkqi != null) {
                this.zzkqi.onStateChanged(this.zzkqj, n, n2, bundle);
            }
        }

        public final void zza(OnStateChangedListener onStateChangedListener) {
            this.zzkqi = onStateChangedListener;
        }
    }

    static final class zzb
    implements LifecycleDelegate {
        private final zzddk zzkqc;

        private zzb(zzddk zzddk2) {
            this.zzkqc = zzddk2;
        }

        private final void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.zzkqc.initialize(walletFragmentInitParams);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void setEnabled(boolean bl) {
            try {
                this.zzkqc.setEnabled(bl);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.zzkqc.updateMaskedWalletRequest(maskedWalletRequest);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzkqc.updateMaskedWallet(maskedWallet);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final int getState() {
            try {
                return this.zzkqc.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzkqc.zza(zzn.zzw((Object)activity), walletFragmentOptions, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                this.zzkqc.onCreate(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                return (View)zzn.zzx((IObjectWrapper)this.zzkqc.onCreateView(zzn.zzw((Object)layoutInflater), zzn.zzw((Object)viewGroup), bundle));
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStart() {
            try {
                this.zzkqc.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzkqc.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzkqc.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzkqc.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public final void onDestroyView() {
        }

        public final void onDestroy() {
        }

        public final void onLowMemory() {
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzkqc.onSaveInstanceState(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private final void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.zzkqc.onActivityResult(n, n2, intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /* synthetic */ zzb(zzddk zzddk2, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(zzddk2);
        }
    }

    final class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private /* synthetic */ WalletFragment zzkqk;

        private zzc(WalletFragment walletFragment) {
            this.zzkqk = walletFragment;
        }

        protected final void zza(zzo<zzb> zzo2) {
            Activity activity = this.zzkqk.zzgpe.getActivity();
            if (this.zzkqk.zzkqe == null && this.zzkqk.mCreated && activity != null) {
                try {
                    zzddk zzddk2 = zzdej.zza(activity, (zzk)this.zzkqk.zzkqf, this.zzkqk.zzkpv, this.zzkqk.zzkqh);
                    this.zzkqk.zzkqe = new zzb(zzddk2, null);
                    WalletFragment.zza(this.zzkqk, null);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzo2.zza((LifecycleDelegate)this.zzkqk.zzkqe);
                if (this.zzkqk.zzkpw != null) {
                    this.zzkqk.zzkqe.initialize(this.zzkqk.zzkpw);
                    WalletFragment.zza(this.zzkqk, null);
                }
                if (this.zzkqk.zzkpx != null) {
                    this.zzkqk.zzkqe.updateMaskedWalletRequest(this.zzkqk.zzkpx);
                    WalletFragment.zza(this.zzkqk, null);
                }
                if (this.zzkqk.zzkpy != null) {
                    this.zzkqk.zzkqe.updateMaskedWallet(this.zzkqk.zzkpy);
                    WalletFragment.zza(this.zzkqk, null);
                }
                if (this.zzkqk.zzkpz != null) {
                    this.zzkqk.zzkqe.setEnabled(this.zzkqk.zzkpz);
                    WalletFragment.zza(this.zzkqk, null);
                }
            }
        }

        protected final void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)this.zzkqk.zzgpe.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (this.zzkqk.zzkpv != null && (walletFragmentStyle = this.zzkqk.zzkpv.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = this.zzkqk.zzgpe.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public final void onClick(View view) {
            Activity activity = this.zzkqk.zzgpe.getActivity();
            GooglePlayServicesUtil.showErrorDialogFragment((int)GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity), (Activity)activity, (int)-1);
        }

        /* synthetic */ zzc(WalletFragment walletFragment, com.google.android.gms.wallet.fragment.zzb zzb2) {
            this(walletFragment);
        }
    }
}

