/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzad;
import com.google.android.gms.wallet.zzae;
import java.util.ArrayList;
import java.util.Collection;

public final class PaymentDataRequest
extends zzbfm {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzae();
    boolean zzlcz;
    boolean zzlda;
    CardRequirements zzldb;
    boolean zzldc;
    ShippingAddressRequirements zzldd;
    ArrayList<Integer> zzlbb;
    PaymentMethodTokenizationParameters zzlde;
    TransactionInfo zzldf;
    boolean zzldg;

    PaymentDataRequest(boolean bl, boolean bl2, CardRequirements cardRequirements, boolean bl3, ShippingAddressRequirements shippingAddressRequirements, ArrayList<Integer> arrayList, PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, TransactionInfo transactionInfo, boolean bl4) {
        this.zzlcz = bl;
        this.zzlda = bl2;
        this.zzldb = cardRequirements;
        this.zzldc = bl3;
        this.zzldd = shippingAddressRequirements;
        this.zzlbb = arrayList;
        this.zzlde = paymentMethodTokenizationParameters;
        this.zzldf = transactionInfo;
        this.zzldg = bl4;
    }

    private PaymentDataRequest() {
        this.zzldg = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzlcz);
        zzbfp.zza((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzlda);
        zzbfp.zza((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzldb, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzldc);
        zzbfp.zza((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzldd, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, paymentDataRequest.zzlbb, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzlde, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzldf, (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzldg);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public final boolean isEmailRequired() {
        return this.zzlcz;
    }

    public final boolean isPhoneNumberRequired() {
        return this.zzlda;
    }

    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzldb;
    }

    public final boolean isShippingAddressRequired() {
        return this.zzldc;
    }

    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzldd;
    }

    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzlbb;
    }

    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzlde;
    }

    public final TransactionInfo getTransactionInfo() {
        return this.zzldf;
    }

    public final boolean isUiRequired() {
        return this.zzldg;
    }

    public static Builder newBuilder() {
        return new Builder(new PaymentDataRequest(), null);
    }

    public final class Builder {
        private /* synthetic */ PaymentDataRequest zzldh;

        private Builder(PaymentDataRequest paymentDataRequest) {
            this.zzldh = paymentDataRequest;
        }

        public final Builder setEmailRequired(boolean bl) {
            this.zzldh.zzlcz = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            this.zzldh.zzlda = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            this.zzldh.zzldb = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            this.zzldh.zzldc = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            this.zzldh.zzldd = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (this.zzldh.zzlbb == null) {
                this.zzldh.zzlbb = new ArrayList();
            }
            this.zzldh.zzlbb.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            zzbq.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (this.zzldh.zzlbb == null) {
                this.zzldh.zzlbb = new ArrayList();
            }
            this.zzldh.zzlbb.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            this.zzldh.zzlde = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            this.zzldh.zzldf = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            this.zzldh.zzldg = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            zzbq.checkNotNull(this.zzldh.zzlbb, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
            zzbq.checkNotNull((Object)((Object)this.zzldh.zzldb), (Object)"Card requirements must be set!");
            if (this.zzldh.zzlde != null) {
                zzbq.checkNotNull((Object)((Object)this.zzldh.zzldf), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
            }
            return this.zzldh;
        }

        /* synthetic */ Builder(PaymentDataRequest paymentDataRequest, zzad zzad2) {
            this(paymentDataRequest);
        }
    }
}

