/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.BooleanResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzag;
import com.google.android.gms.internal.wallet.zzah;
import com.google.android.gms.internal.wallet.zzai;
import com.google.android.gms.internal.wallet.zzaj;
import com.google.android.gms.internal.wallet.zzak;
import com.google.android.gms.internal.wallet.zzal;
import com.google.android.gms.internal.wallet.zzs;
import com.google.android.gms.internal.wallet.zzt;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.FullWallet;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;

public final class zzaf
extends GmsClient<zzs> {
    private final Context zzgj;
    private final int environment;
    private final String zzcj;
    private final int theme;
    private final boolean zzet;

    public zzaf(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzgj = context;
        this.environment = n;
        this.zzcj = clientSettings.getAccountName();
        this.theme = n2;
        this.zzet = bl;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zzb(int n) {
        Bundle bundle = this.zzd();
        zzag zzag2 = new zzag((Activity)this.zzgj, n);
        try {
            ((zzs)this.getService()).zza(bundle, zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during checkForPreAuthorization", (Throwable)remoteException);
            ((zzah)zzag2).zza(8, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(String string, String string2, int n) {
        int n2 = n;
        String string3 = string2;
        String string4 = string;
        Activity activity = (Activity)this.zzgj;
        zzaf zzaf2 = this;
        Bundle bundle = zzaf2.zzd();
        zzag zzag2 = new zzag(activity, n2);
        try {
            ((zzs)zzaf2.getService()).zza(string4, string3, bundle, zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException changing masked wallet", (Throwable)remoteException);
            ((zzah)zzag2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(MaskedWalletRequest maskedWalletRequest, int n) {
        int n2 = n;
        MaskedWalletRequest maskedWalletRequest2 = maskedWalletRequest;
        Activity activity = (Activity)this.zzgj;
        zzaf zzaf2 = this;
        Bundle bundle = zzaf2.zzd();
        zzag zzag2 = new zzag(activity, n2);
        try {
            ((zzs)zzaf2.getService()).zza(maskedWalletRequest2, bundle, (zzw)zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting masked wallet", (Throwable)remoteException);
            ((zzah)zzag2).zza(8, (MaskedWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(FullWalletRequest fullWalletRequest, int n) {
        int n2 = n;
        FullWalletRequest fullWalletRequest2 = fullWalletRequest;
        Activity activity = (Activity)this.zzgj;
        zzaf zzaf2 = this;
        zzag zzag2 = new zzag(activity, n2);
        Bundle bundle = zzaf2.zzd();
        try {
            ((zzs)zzaf2.getService()).zza(fullWalletRequest2, bundle, (zzw)zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting full wallet", (Throwable)remoteException);
            ((zzah)zzag2).zza(8, (FullWallet)null, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzag zzag2 = new zzag((Activity)this.zzgj, n);
        Bundle bundle = this.zzd();
        try {
            ((zzs)this.getService()).zza(createWalletObjectsRequest, bundle, (zzw)zzag2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzah)zzag2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzaj zzaj2 = new zzaj(taskCompletionSource);
        try {
            ((zzs)this.getService()).zza(createWalletObjectsRequest, bundle, (zzw)zzaj2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzah)zzaj2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, BaseImplementation.ResultHolder<BooleanResult> resultHolder) {
        zzak zzak2 = new zzak(resultHolder);
        Bundle bundle = this.zzd();
        try {
            ((zzs)this.getService()).zza(isReadyToPayRequest, bundle, (zzw)zzak2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzah)zzak2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzai zzai2 = new zzai(taskCompletionSource);
        try {
            ((zzs)this.getService()).zza(isReadyToPayRequest, this.zzd(), (zzw)zzai2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzah)zzai2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zzd();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzal zzal2 = new zzal(taskCompletionSource);
        try {
            ((zzs)this.getService()).zza(paymentDataRequest, bundle, (zzw)zzal2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzah)zzal2).zza(Status.RESULT_INTERNAL_ERROR, (PaymentData)null, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zzd() {
        boolean bl = this.zzet;
        int n = this.theme;
        String string = this.zzcj;
        String string2 = this.zzgj.getPackageName();
        int n2 = this.environment;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    public final int getMinApkVersion() {
        return 12600000;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzs) {
            return (zzs)iInterface;
        }
        return new zzt(iBinder2);
    }
}

