/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.button;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.wallet.R;
import com.google.android.gms.wallet.button.ButtonOptions;
import com.google.android.gms.wallet.button.zzf;

public final class PayButton
extends FrameLayout
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener zza;
    private ButtonOptions.Builder zzb;
    @Nullable
    private View zzc;
    private final zzf zzd;

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PayButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_4);
        void var3_4;
        void var2_2;
        TypedArray typedArray;
        ButtonOptions.Builder builder = this.zzb = ButtonOptions.newBuilder();
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.PayButtonAttributes);
        int n = typedArray.getInt(R.styleable.PayButtonAttributes_buttonTheme, 1);
        int n2 = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
        ButtonOptions buttonOptions = builder.ButtonOptions.this;
        buttonOptions.zzb = n;
        buttonOptions.zzc = typedArray.getDimensionPixelSize(R.styleable.PayButtonAttributes_cornerRadius, n2);
        if (typedArray.hasValue(R.styleable.PayButtonAttributes_cornerRadius)) {
            builder.ButtonOptions.this.zze = true;
        }
        typedArray.recycle();
        builder.setButtonType(1);
        this.zzd = new zzf();
    }

    public void initialize(@NonNull ButtonOptions options) {
        ButtonOptions buttonOptions;
        ButtonOptions.Builder builder = this.zzb;
        if (buttonOptions.getButtonType() != 0) {
            builder.ButtonOptions.this.zza = buttonOptions.getButtonType();
        }
        if (buttonOptions.getButtonTheme() != 0) {
            builder.ButtonOptions.this.zzb = buttonOptions.getButtonTheme();
        }
        if (buttonOptions.zze) {
            builder.setCornerRadius(buttonOptions.getCornerRadius());
        }
        if (buttonOptions.getAllowedPaymentMethods() != null) {
            builder.ButtonOptions.this.zzd = buttonOptions.getAllowedPaymentMethods();
        }
        this.removeAllViews();
        buttonOptions = this.zzb.build();
        if (TextUtils.isEmpty((CharSequence)buttonOptions.getAllowedPaymentMethods())) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView: allowedPaymentMethods cannot be empty.");
            return;
        }
        this.zzc = zzf.zza((Context)Preconditions.checkNotNull((Object)this.getContext()), buttonOptions);
        buttonOptions = this.zzc;
        if (buttonOptions == null) {
            Log.e((String)"PayButton", (String)"Failed to create buttonView");
            return;
        }
        this.addView((View)buttonOptions);
        this.zzc.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(@NonNull View view) {
        void var1_1;
        View.OnClickListener onClickListener = this.zza;
        if (onClickListener != null && var1_1 == this.zzc) {
            onClickListener.onClick((View)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        void var1_1;
        this.zza = var1_1;
    }
}

