/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.Cart;
import com.google.android.gms.wallet.CountrySpecification;
import com.google.android.gms.wallet.zzm;
import java.util.ArrayList;
import java.util.Collection;

public final class MaskedWalletRequest
implements SafeParcelable {
    public static final Parcelable.Creator<MaskedWalletRequest> CREATOR = new zzm();
    private final int zzFG;
    String zzaCZ;
    boolean zzaDT;
    boolean zzaDU;
    boolean zzaDV;
    String zzaDW;
    String zzaCS;
    String zzaDX;
    Cart zzaDi;
    boolean zzaDY;
    boolean zzaDZ;
    CountrySpecification[] zzaEa;
    boolean zzaEb;
    boolean zzaEc;
    ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> zzaEd;

    public static Builder newBuilder() {
        MaskedWalletRequest maskedWalletRequest = new MaskedWalletRequest();
        maskedWalletRequest.getClass();
        return maskedWalletRequest.new Builder();
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzm.zza(this, dest, flags);
    }

    MaskedWalletRequest(int versionCode, String merchantTransactionId, boolean phoneNumberRequired, boolean shippingAddressRequired, boolean useMinimalBillingAddress, String estimatedTotalPrice, String currencyCode, String merchantName, Cart cart, boolean shouldRetrieveWalletObjects, boolean isBillingAgreement, CountrySpecification[] allowedShippingCountrySpecifications, boolean allowPrepaidCard, boolean allowDebitCard, ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> allowedCountrySpecificationsForShipping) {
        this.zzFG = versionCode;
        this.zzaCZ = merchantTransactionId;
        this.zzaDT = phoneNumberRequired;
        this.zzaDU = shippingAddressRequired;
        this.zzaDV = useMinimalBillingAddress;
        this.zzaDW = estimatedTotalPrice;
        this.zzaCS = currencyCode;
        this.zzaDX = merchantName;
        this.zzaDi = cart;
        this.zzaDY = shouldRetrieveWalletObjects;
        this.zzaDZ = isBillingAgreement;
        this.zzaEa = allowedShippingCountrySpecifications;
        this.zzaEb = allowPrepaidCard;
        this.zzaEc = allowDebitCard;
        this.zzaEd = allowedCountrySpecificationsForShipping;
    }

    MaskedWalletRequest() {
        this.zzFG = 3;
        this.zzaEb = true;
        this.zzaEc = true;
    }

    public String getMerchantTransactionId() {
        return this.zzaCZ;
    }

    public boolean isPhoneNumberRequired() {
        return this.zzaDT;
    }

    public boolean isShippingAddressRequired() {
        return this.zzaDU;
    }

    public boolean useMinimalBillingAddress() {
        return this.zzaDV;
    }

    public String getEstimatedTotalPrice() {
        return this.zzaDW;
    }

    public String getCurrencyCode() {
        return this.zzaCS;
    }

    public String getMerchantName() {
        return this.zzaDX;
    }

    public Cart getCart() {
        return this.zzaDi;
    }

    public boolean shouldRetrieveWalletObjects() {
        return this.zzaDY;
    }

    public boolean isBillingAgreement() {
        return this.zzaDZ;
    }

    public CountrySpecification[] getAllowedShippingCountrySpecifications() {
        return this.zzaEa;
    }

    public boolean allowPrepaidCard() {
        return this.zzaEb;
    }

    public boolean allowDebitCard() {
        return this.zzaEc;
    }

    public ArrayList<com.google.android.gms.identity.intents.model.CountrySpecification> getAllowedCountrySpecificationsForShipping() {
        return this.zzaEd;
    }

    public final class Builder {
        private Builder() {
        }

        public Builder setMerchantTransactionId(String merchantTransactionId) {
            MaskedWalletRequest.this.zzaCZ = merchantTransactionId;
            return this;
        }

        public Builder setPhoneNumberRequired(boolean phoneNumberRequired) {
            MaskedWalletRequest.this.zzaDT = phoneNumberRequired;
            return this;
        }

        public Builder setShippingAddressRequired(boolean shippingAddressRequired) {
            MaskedWalletRequest.this.zzaDU = shippingAddressRequired;
            return this;
        }

        public Builder setUseMinimalBillingAddress(boolean useMinimalBillingAddress) {
            MaskedWalletRequest.this.zzaDV = useMinimalBillingAddress;
            return this;
        }

        public Builder setEstimatedTotalPrice(String estimatedTotalPrice) {
            MaskedWalletRequest.this.zzaDW = estimatedTotalPrice;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            MaskedWalletRequest.this.zzaCS = currencyCode;
            return this;
        }

        public Builder setMerchantName(String merchantName) {
            MaskedWalletRequest.this.zzaDX = merchantName;
            return this;
        }

        public Builder setCart(Cart cart) {
            MaskedWalletRequest.this.zzaDi = cart;
            return this;
        }

        public Builder setShouldRetrieveWalletObjects(boolean shouldRetrieveWalletObjects) {
            MaskedWalletRequest.this.zzaDY = shouldRetrieveWalletObjects;
            return this;
        }

        public Builder setIsBillingAgreement(boolean isBillingAgreement) {
            MaskedWalletRequest.this.zzaDZ = isBillingAgreement;
            return this;
        }

        public Builder setAllowPrepaidCard(boolean allowPrepaidCard) {
            MaskedWalletRequest.this.zzaEb = allowPrepaidCard;
            return this;
        }

        public Builder setAllowDebitCard(boolean allowDebitCard) {
            MaskedWalletRequest.this.zzaEc = allowDebitCard;
            return this;
        }

        public Builder addAllowedCountrySpecificationForShipping(com.google.android.gms.identity.intents.model.CountrySpecification countrySpecification) {
            if (MaskedWalletRequest.this.zzaEd == null) {
                MaskedWalletRequest.this.zzaEd = new ArrayList();
            }
            MaskedWalletRequest.this.zzaEd.add(countrySpecification);
            return this;
        }

        public Builder addAllowedCountrySpecificationsForShipping(Collection<com.google.android.gms.identity.intents.model.CountrySpecification> countrySpecifications) {
            if (countrySpecifications != null) {
                if (MaskedWalletRequest.this.zzaEd == null) {
                    MaskedWalletRequest.this.zzaEd = new ArrayList();
                }
                MaskedWalletRequest.this.zzaEd.addAll(countrySpecifications);
            }
            return this;
        }

        public MaskedWalletRequest build() {
            return MaskedWalletRequest.this;
        }
    }
}

